/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.attributes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class AttributesUtil {
    public static final String XML_TAG = "attributes";
    public static final String XML_TAG_GROUP = "group";
    public static final String XML_TAG_ATTRIBUTE = "attribute";

    public static String getAttributesXml(Map<String, Map<String, String>> attributesMap) {
        return AttributesUtil.getAttributesXml(attributesMap, XML_TAG);
    }

    public static String getAttributesXml(Map<String, Map<String, String>> attributesMap, String xmlTag) {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.openTag((String)xmlTag));
        if (attributesMap != null && !attributesMap.isEmpty()) {
            ArrayList<String> groupNames = new ArrayList<String>(attributesMap.keySet());
            Collections.sort(groupNames);
            for (String groupName : groupNames) {
                xml.append(XmlHandler.openTag((String)XML_TAG_GROUP));
                xml.append(XmlHandler.addTagValue((String)"name", (String)groupName));
                Map<String, String> attributes = attributesMap.get(groupName);
                ArrayList<String> keys = new ArrayList<String>(attributes.keySet());
                for (String key : keys) {
                    xml.append(XmlHandler.openTag((String)XML_TAG_ATTRIBUTE));
                    xml.append(XmlHandler.addTagValue((String)"key", (String)key));
                    xml.append(XmlHandler.addTagValue((String)"value", (String)attributes.get(key)));
                    xml.append(XmlHandler.closeTag((String)XML_TAG_ATTRIBUTE));
                }
                xml.append(XmlHandler.closeTag((String)XML_TAG_GROUP));
            }
        }
        xml.append(XmlHandler.closeTag((String)xmlTag)).append(Const.CR);
        return xml.toString();
    }

    public static Map<String, Map<String, String>> loadAttributes(Node attributesNode) {
        HashMap<String, Map<String, String>> attributesMap = new HashMap<String, Map<String, String>>();
        if (attributesNode != null) {
            List groupNodes = XmlHandler.getNodes((Node)attributesNode, (String)XML_TAG_GROUP);
            for (Node groupNode : groupNodes) {
                String groupName = XmlHandler.getTagValue((Node)groupNode, (String)"name");
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributesMap.put(groupName, attributes);
                List attributeNodes = XmlHandler.getNodes((Node)groupNode, (String)XML_TAG_ATTRIBUTE);
                for (Node attributeNode : attributeNodes) {
                    String key = XmlHandler.getTagValue((Node)attributeNode, (String)"key");
                    String value = XmlHandler.getTagValue((Node)attributeNode, (String)"value");
                    if (key == null || value == null) continue;
                    attributes.put(key, value);
                }
            }
        }
        return attributesMap;
    }
}

