/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.tags;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.common.Scope;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.internal.NoopScope;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.internal.Utils;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.tags.Tag;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.tags.TagContext;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.tags.TagContextBuilder;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.tags.TagKey;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.tags.TagMetadata;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.tags.TagValue;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.tags.Tagger;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.tags.TaggingState;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.tags.TagsComponent;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.tags.propagation.TagContextBinarySerializer;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.tags.propagation.TagContextDeserializationException;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.tags.propagation.TagContextSerializationException;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.tags.propagation.TagContextTextFormat;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.tags.propagation.TagPropagationComponent;

final class NoopTags {
    private NoopTags() {
    }

    static TagsComponent newNoopTagsComponent() {
        return new NoopTagsComponent();
    }

    static Tagger getNoopTagger() {
        return NoopTagger.INSTANCE;
    }

    static TagContextBuilder getNoopTagContextBuilder() {
        return NoopTagContextBuilder.INSTANCE;
    }

    static TagContext getNoopTagContext() {
        return NoopTagContext.INSTANCE;
    }

    static TagPropagationComponent getNoopTagPropagationComponent() {
        return NoopTagPropagationComponent.INSTANCE;
    }

    static TagContextBinarySerializer getNoopTagContextBinarySerializer() {
        return NoopTagContextBinarySerializer.INSTANCE;
    }

    static TagContextTextFormat getNoopTagContextTextSerializer() {
        return NoopTagContextTextFormat.INSTANCE;
    }

    @Immutable
    private static final class NoopTagContextTextFormat
    extends TagContextTextFormat {
        static final NoopTagContextTextFormat INSTANCE = new NoopTagContextTextFormat();

        private NoopTagContextTextFormat() {
        }

        @Override
        public List<String> fields() {
            return Collections.emptyList();
        }

        @Override
        public <C> void inject(TagContext tagContext, C carrier, TagContextTextFormat.Setter<C> setter) throws TagContextSerializationException {
            Utils.checkNotNull(tagContext, "tagContext");
            Utils.checkNotNull(carrier, "carrier");
            Utils.checkNotNull(setter, "setter");
        }

        @Override
        public <C> TagContext extract(C carrier, TagContextTextFormat.Getter<C> getter) throws TagContextDeserializationException {
            Utils.checkNotNull(carrier, "carrier");
            Utils.checkNotNull(getter, "getter");
            return NoopTags.getNoopTagContext();
        }
    }

    @Immutable
    private static final class NoopTagContextBinarySerializer
    extends TagContextBinarySerializer {
        static final TagContextBinarySerializer INSTANCE = new NoopTagContextBinarySerializer();
        static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

        private NoopTagContextBinarySerializer() {
        }

        @Override
        public byte[] toByteArray(TagContext tags) {
            Utils.checkNotNull(tags, "tags");
            return EMPTY_BYTE_ARRAY;
        }

        @Override
        public TagContext fromByteArray(byte[] bytes) {
            Utils.checkNotNull(bytes, "bytes");
            return NoopTags.getNoopTagContext();
        }
    }

    @Immutable
    private static final class NoopTagPropagationComponent
    extends TagPropagationComponent {
        static final TagPropagationComponent INSTANCE = new NoopTagPropagationComponent();

        private NoopTagPropagationComponent() {
        }

        @Override
        public TagContextBinarySerializer getBinarySerializer() {
            return NoopTags.getNoopTagContextBinarySerializer();
        }

        @Override
        public TagContextTextFormat getCorrelationContextFormat() {
            return NoopTags.getNoopTagContextTextSerializer();
        }
    }

    @Immutable
    private static final class NoopTagContext
    extends TagContext {
        static final TagContext INSTANCE = new NoopTagContext();

        private NoopTagContext() {
        }

        @Override
        protected Iterator<Tag> getIterator() {
            return Collections.emptySet().iterator();
        }
    }

    @Immutable
    private static final class NoopTagContextBuilder
    extends TagContextBuilder {
        static final TagContextBuilder INSTANCE = new NoopTagContextBuilder();

        private NoopTagContextBuilder() {
        }

        @Override
        public TagContextBuilder put(TagKey key, TagValue value) {
            Utils.checkNotNull(key, "key");
            Utils.checkNotNull(value, "value");
            return this;
        }

        @Override
        public TagContextBuilder put(TagKey key, TagValue value, TagMetadata tagMetadata) {
            Utils.checkNotNull(key, "key");
            Utils.checkNotNull(value, "value");
            Utils.checkNotNull(tagMetadata, "tagMetadata");
            return this;
        }

        @Override
        public TagContextBuilder remove(TagKey key) {
            Utils.checkNotNull(key, "key");
            return this;
        }

        @Override
        public TagContext build() {
            return NoopTags.getNoopTagContext();
        }

        @Override
        public Scope buildScoped() {
            return NoopScope.getInstance();
        }
    }

    @Immutable
    private static final class NoopTagger
    extends Tagger {
        static final Tagger INSTANCE = new NoopTagger();

        private NoopTagger() {
        }

        @Override
        public TagContext empty() {
            return NoopTags.getNoopTagContext();
        }

        @Override
        public TagContext getCurrentTagContext() {
            return NoopTags.getNoopTagContext();
        }

        @Override
        public TagContextBuilder emptyBuilder() {
            return NoopTags.getNoopTagContextBuilder();
        }

        @Override
        public TagContextBuilder toBuilder(TagContext tags) {
            Utils.checkNotNull(tags, "tags");
            return NoopTags.getNoopTagContextBuilder();
        }

        @Override
        public TagContextBuilder currentBuilder() {
            return NoopTags.getNoopTagContextBuilder();
        }

        @Override
        public Scope withTagContext(TagContext tags) {
            Utils.checkNotNull(tags, "tags");
            return NoopScope.getInstance();
        }
    }

    @ThreadSafe
    private static final class NoopTagsComponent
    extends TagsComponent {
        private volatile boolean isRead;

        private NoopTagsComponent() {
        }

        @Override
        public Tagger getTagger() {
            return NoopTags.getNoopTagger();
        }

        @Override
        public TagPropagationComponent getTagPropagationComponent() {
            return NoopTags.getNoopTagPropagationComponent();
        }

        @Override
        public TaggingState getState() {
            this.isRead = true;
            return TaggingState.DISABLED;
        }

        @Override
        @Deprecated
        public void setState(TaggingState state) {
            Utils.checkNotNull(state, "state");
            Utils.checkState(!this.isRead, "State was already read, cannot set state.");
        }
    }
}

