/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p48p1.io.grpc.internal;

import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.common.base.Preconditions;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.Attributes;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.CallCredentials;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.CallOptions;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.ChannelCredentials;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.ChannelLogger;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.ClientStreamTracer;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.CompositeCallCredentials;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.Metadata;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.MethodDescriptor;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.SecurityLevel;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.internal.ClientStream;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.internal.ClientTransportFactory;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.internal.ConnectionClientTransport;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.internal.FailingClientStream;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.internal.ForwardingConnectionClientTransport;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.internal.GrpcAttributes;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.internal.MetadataApplierImpl;

final class CallCredentialsApplyingTransportFactory
implements ClientTransportFactory {
    private final ClientTransportFactory delegate;
    private final CallCredentials channelCallCredentials;
    private final Executor appExecutor;

    CallCredentialsApplyingTransportFactory(ClientTransportFactory delegate, CallCredentials channelCallCredentials, Executor appExecutor) {
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        this.channelCallCredentials = channelCallCredentials;
        this.appExecutor = Preconditions.checkNotNull(appExecutor, "appExecutor");
    }

    @Override
    public ConnectionClientTransport newClientTransport(SocketAddress serverAddress, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
        return new CallCredentialsApplyingTransport(this.delegate.newClientTransport(serverAddress, options, channelLogger), options.getAuthority());
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.delegate.getScheduledExecutorService();
    }

    @Override
    public ClientTransportFactory.SwapChannelCredentialsResult swapChannelCredentials(ChannelCredentials channelCreds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private class CallCredentialsApplyingTransport
    extends ForwardingConnectionClientTransport {
        private final ConnectionClientTransport delegate;
        private final String authority;
        private final AtomicInteger pendingApplier = new AtomicInteger(-2147483647);
        private volatile Status shutdownStatus;
        @GuardedBy(value="this")
        private Status savedShutdownStatus;
        @GuardedBy(value="this")
        private Status savedShutdownNowStatus;
        private final MetadataApplierImpl.MetadataApplierListener applierListener = new MetadataApplierImpl.MetadataApplierListener(){

            @Override
            public void onComplete() {
                if (CallCredentialsApplyingTransport.this.pendingApplier.decrementAndGet() == 0) {
                    CallCredentialsApplyingTransport.this.maybeShutdown();
                }
            }
        };

        CallCredentialsApplyingTransport(ConnectionClientTransport delegate, String authority) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.authority = Preconditions.checkNotNull(authority, "authority");
        }

        @Override
        protected ConnectionClientTransport delegate() {
            return this.delegate;
        }

        @Override
        public ClientStream newStream(final MethodDescriptor<?, ?> method, Metadata headers, final CallOptions callOptions, ClientStreamTracer[] tracers) {
            CallCredentials creds = callOptions.getCredentials();
            if (creds == null) {
                creds = CallCredentialsApplyingTransportFactory.this.channelCallCredentials;
            } else if (CallCredentialsApplyingTransportFactory.this.channelCallCredentials != null) {
                creds = new CompositeCallCredentials(CallCredentialsApplyingTransportFactory.this.channelCallCredentials, creds);
            }
            if (creds != null) {
                MetadataApplierImpl applier = new MetadataApplierImpl(this.delegate, method, headers, callOptions, this.applierListener, tracers);
                if (this.pendingApplier.incrementAndGet() > 0) {
                    this.applierListener.onComplete();
                    return new FailingClientStream(this.shutdownStatus, tracers);
                }
                CallCredentials.RequestInfo requestInfo = new CallCredentials.RequestInfo(){

                    @Override
                    public MethodDescriptor<?, ?> getMethodDescriptor() {
                        return method;
                    }

                    @Override
                    public SecurityLevel getSecurityLevel() {
                        return MoreObjects.firstNonNull(CallCredentialsApplyingTransport.this.delegate.getAttributes().get(GrpcAttributes.ATTR_SECURITY_LEVEL), SecurityLevel.NONE);
                    }

                    @Override
                    public String getAuthority() {
                        return MoreObjects.firstNonNull(callOptions.getAuthority(), CallCredentialsApplyingTransport.this.authority);
                    }

                    @Override
                    public Attributes getTransportAttrs() {
                        return CallCredentialsApplyingTransport.this.delegate.getAttributes();
                    }
                };
                try {
                    creds.applyRequestMetadata(requestInfo, CallCredentialsApplyingTransportFactory.this.appExecutor, applier);
                }
                catch (Throwable t) {
                    applier.fail(Status.UNAUTHENTICATED.withDescription("Credentials should use fail() instead of throwing exceptions").withCause(t));
                }
                return applier.returnStream();
            }
            if (this.pendingApplier.get() >= 0) {
                return new FailingClientStream(this.shutdownStatus, tracers);
            }
            return this.delegate.newStream(method, headers, callOptions, tracers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown(Status status) {
            Preconditions.checkNotNull(status, "status");
            CallCredentialsApplyingTransport callCredentialsApplyingTransport = this;
            synchronized (callCredentialsApplyingTransport) {
                if (this.pendingApplier.get() >= 0) {
                    return;
                }
                this.shutdownStatus = status;
                this.pendingApplier.addAndGet(Integer.MAX_VALUE);
                if (this.pendingApplier.get() != 0) {
                    this.savedShutdownStatus = status;
                    return;
                }
            }
            super.shutdown(status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdownNow(Status status) {
            Preconditions.checkNotNull(status, "status");
            CallCredentialsApplyingTransport callCredentialsApplyingTransport = this;
            synchronized (callCredentialsApplyingTransport) {
                if (this.pendingApplier.get() < 0) {
                    this.shutdownStatus = status;
                    this.pendingApplier.addAndGet(Integer.MAX_VALUE);
                } else if (this.savedShutdownNowStatus != null) {
                    return;
                }
                if (this.pendingApplier.get() != 0) {
                    this.savedShutdownNowStatus = status;
                    return;
                }
            }
            super.shutdownNow(status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeShutdown() {
            Status maybeShutdownNow;
            Status maybeShutdown;
            CallCredentialsApplyingTransport callCredentialsApplyingTransport = this;
            synchronized (callCredentialsApplyingTransport) {
                if (this.pendingApplier.get() != 0) {
                    return;
                }
                maybeShutdown = this.savedShutdownStatus;
                maybeShutdownNow = this.savedShutdownNowStatus;
                this.savedShutdownStatus = null;
                this.savedShutdownNowStatus = null;
            }
            if (maybeShutdown != null) {
                super.shutdown(maybeShutdown);
            }
            if (maybeShutdownNow != null) {
                super.shutdownNow(maybeShutdownNow);
            }
        }
    }
}

