/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic.delay;

import java.util.Random;
import org.apache.beam.sdk.io.synthetic.SyntheticSourceOptions;
import org.apache.beam.sdk.io.synthetic.delay.SyntheticDelay;

public class ReaderDelay {
    private SyntheticSourceOptions options;

    public ReaderDelay(SyntheticSourceOptions options) {
        this.options = options;
    }

    public void delayRecord(SyntheticSourceOptions.Record record) {
        long hashCodeOfVal = this.options.hashFunction().hashBytes((byte[])record.kv.getValue()).asLong();
        Random random = new Random(hashCodeOfVal);
        SyntheticDelay.delay(record.sleepMsec, this.options.cpuUtilizationInMixedDelay, this.options.delayType, random);
    }

    public void delayStart(long currentElement) {
        SyntheticDelay.delay(this.options.nextInitializeDelay(currentElement), this.options.cpuUtilizationInMixedDelay, this.options.delayType, new Random(currentElement));
    }
}

