/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filterrows;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Condition;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.filterrows.FilterRowsMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ConditionEditor;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FilterRowsDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = FilterRowsMeta.class;
    private CCombo wTrueTo;
    private CCombo wFalseTo;
    private ConditionEditor wCondition;
    private final FilterRowsMeta input;
    private final Condition condition;
    private Condition backupCondition;

    public FilterRowsDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (FilterRowsMeta)((Object)in);
        this.condition = new Condition(this.input.getCondition());
    }

    public String open() {
        RowMeta inputfields;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.backupChanged = this.input.hasChanged();
        this.backupCondition = new Condition(this.condition);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FilterRowsDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"FilterRowsDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlTrueTo = new Label((Composite)this.shell, 131072);
        wlTrueTo.setText(BaseMessages.getString(PKG, (String)"FilterRowsDialog.SendTrueTo.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTrueTo);
        FormData fdlTrueTo = new FormData();
        fdlTrueTo.left = new FormAttachment(0, 0);
        fdlTrueTo.right = new FormAttachment(middle, -margin);
        fdlTrueTo.top = new FormAttachment((Control)this.wTransformName, margin);
        wlTrueTo.setLayoutData((Object)fdlTrueTo);
        this.wTrueTo = new CCombo((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTrueTo);
        TransformMeta transforminfo = this.pipelineMeta.findTransform(this.transformName);
        if (transforminfo != null) {
            List nextTransforms = this.pipelineMeta.findNextTransforms(transforminfo);
            for (TransformMeta transformMeta : nextTransforms) {
                this.wTrueTo.add(transformMeta.getName());
            }
        }
        this.wTrueTo.addModifyListener(lsMod);
        FormData fdTrueTo = new FormData();
        fdTrueTo.left = new FormAttachment(middle, 0);
        fdTrueTo.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTrueTo.right = new FormAttachment(100, 0);
        this.wTrueTo.setLayoutData((Object)fdTrueTo);
        Label wlFalseTo = new Label((Composite)this.shell, 131072);
        wlFalseTo.setText(BaseMessages.getString(PKG, (String)"FilterRowsDialog.SendFalseTo.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFalseTo);
        FormData fdlFalseTo = new FormData();
        fdlFalseTo.left = new FormAttachment(0, 0);
        fdlFalseTo.right = new FormAttachment(middle, -margin);
        fdlFalseTo.top = new FormAttachment((Control)this.wTrueTo, margin);
        wlFalseTo.setLayoutData((Object)fdlFalseTo);
        this.wFalseTo = new CCombo((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wFalseTo);
        transforminfo = this.pipelineMeta.findTransform(this.transformName);
        if (transforminfo != null) {
            List nextTransforms = this.pipelineMeta.findNextTransforms(transforminfo);
            for (TransformMeta transformMeta : nextTransforms) {
                this.wFalseTo.add(transformMeta.getName());
            }
        }
        this.wFalseTo.addModifyListener(lsMod);
        FormData fdFalseFrom = new FormData();
        fdFalseFrom.left = new FormAttachment(middle, 0);
        fdFalseFrom.top = new FormAttachment((Control)this.wTrueTo, margin);
        fdFalseFrom.right = new FormAttachment(100, 0);
        this.wFalseTo.setLayoutData((Object)fdFalseFrom);
        Label wlCondition = new Label((Composite)this.shell, 0);
        wlCondition.setText(BaseMessages.getString(PKG, (String)"FilterRowsDialog.Condition.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCondition);
        FormData fdlCondition = new FormData();
        fdlCondition.left = new FormAttachment(0, 0);
        fdlCondition.top = new FormAttachment((Control)this.wFalseTo, margin);
        wlCondition.setLayoutData((Object)fdlCondition);
        try {
            inputfields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
        }
        catch (HopException ke) {
            inputfields = new RowMeta();
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FilterRowsDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FilterRowsDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wCondition = new ConditionEditor((Composite)this.shell, 2048, this.condition, (IRowMeta)inputfields);
        FormData fdCondition = new FormData();
        fdCondition.left = new FormAttachment(0, 0);
        fdCondition.top = new FormAttachment((Control)wlCondition, margin);
        fdCondition.right = new FormAttachment(100, 0);
        fdCondition.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wCondition.setLayoutData((Object)fdCondition);
        this.wCondition.addModifyListener(lsMod);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        this.input.setChanged(this.backupChanged);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        List targetStreams = this.input.getTransformIOMeta().getTargetStreams();
        this.wTrueTo.setText(Const.NVL((String)((IStream)targetStreams.get(0)).getTransformName(), (String)""));
        this.wFalseTo.setText(Const.NVL((String)((IStream)targetStreams.get(1)).getTransformName(), (String)""));
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.input.setCondition(this.backupCondition);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        if (this.wCondition.getLevel() > 0) {
            this.wCondition.goUp();
        } else {
            String falseTransformName;
            String trueTransformName = this.wTrueTo.getText();
            if (StringUtils.isEmpty((String)trueTransformName)) {
                trueTransformName = null;
            }
            if (StringUtils.isEmpty((String)(falseTransformName = this.wFalseTo.getText()))) {
                falseTransformName = null;
            }
            this.input.setTrueTransformName(trueTransformName);
            this.input.setFalseTransformName(falseTransformName);
            this.input.searchInfoAndTargetTransforms(this.pipelineMeta.getTransforms());
            this.transformName = this.wTransformName.getText();
            this.input.setCondition(this.condition);
            this.dispose();
        }
    }
}

