/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.common.base.Preconditions;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

public class SpannerApiFutures {
    public static <T> T get(ApiFuture<T> future) throws SpannerException {
        return SpannerApiFutures.getOrNull((ApiFuture)Preconditions.checkNotNull(future));
    }

    public static <T> T getOrNull(ApiFuture<T> future) throws SpannerException {
        try {
            return (T)(future == null ? null : future.get());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SpannerException) {
                throw (SpannerException)((Object)e.getCause());
            }
            throw SpannerExceptionFactory.newSpannerException(e.getCause());
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt(e);
        }
        catch (CancellationException e) {
            throw SpannerExceptionFactory.newSpannerExceptionForCancellation(null, e);
        }
    }
}

