/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.BackupId;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.encryption.RestoreEncryptionConfig;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;

public class Restore {
    private final BackupId source;
    private final DatabaseId destination;
    private final RestoreEncryptionConfig encryptionConfig;

    Restore(Builder builder) {
        this(builder.source, builder.destination, builder.encryptionConfig);
    }

    @VisibleForTesting
    Restore(BackupId source, DatabaseId destination, RestoreEncryptionConfig encryptionConfig) {
        this.source = source;
        this.destination = destination;
        this.encryptionConfig = encryptionConfig;
    }

    public BackupId getSource() {
        return this.source;
    }

    public DatabaseId getDestination() {
        return this.destination;
    }

    public RestoreEncryptionConfig getEncryptionConfig() {
        return this.encryptionConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Restore restore = (Restore)o;
        return Objects.equals(this.source, restore.source) && Objects.equals(this.destination, restore.destination) && Objects.equals(this.encryptionConfig, restore.encryptionConfig);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.destination, this.encryptionConfig);
    }

    public String toString() {
        return String.format("Restore[%s, %s, %s]", this.source.getName(), this.destination.getName(), this.encryptionConfig);
    }

    public static class Builder {
        private final BackupId source;
        private final DatabaseId destination;
        private RestoreEncryptionConfig encryptionConfig;

        public Builder(BackupId source, DatabaseId destination) {
            this.source = source;
            this.destination = destination;
        }

        public Builder setEncryptionConfig(RestoreEncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        public Restore build() {
            return new Restore(this);
        }
    }
}

