/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction.resources;

import io.github.classgraph.ClassGraph;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.direct_java.runners.core.construction.resources.PipelineResourcesDetector;

public class ClasspathScanningResourcesDetector
implements PipelineResourcesDetector {
    private transient ClassGraph classGraph;

    public ClasspathScanningResourcesDetector(ClassGraph classGraph) {
        this.classGraph = classGraph;
    }

    @Override
    public List<String> detect(ClassLoader classLoader) {
        List classpathContents = this.classGraph.disableNestedJarScanning().addClassLoader(classLoader).scan(1).getClasspathFiles();
        return classpathContents.stream().map(File::getAbsolutePath).collect(Collectors.toList());
    }
}

