/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction.graph;

import com.google.auto.value.AutoValue;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.AutoValue_SideInputReference;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;

@AutoValue
public abstract class SideInputReference {
    public static SideInputReference of(PipelineNode.PTransformNode transform, String localName, PipelineNode.PCollectionNode collection) {
        return new AutoValue_SideInputReference(transform, localName, collection);
    }

    public static SideInputReference fromSideInputId(RunnerApi.ExecutableStagePayload.SideInputId sideInputId, RunnerApi.Components components) {
        String transformId = sideInputId.getTransformId();
        String localName = sideInputId.getLocalName();
        String collectionId = components.getTransformsOrThrow(transformId).getInputsOrThrow(localName);
        RunnerApi.PTransform transform = components.getTransformsOrThrow(transformId);
        RunnerApi.PCollection collection = components.getPcollectionsOrThrow(collectionId);
        return SideInputReference.of(PipelineNode.pTransform(transformId, transform), localName, PipelineNode.pCollection(collectionId, collection));
    }

    public abstract PipelineNode.PTransformNode transform();

    public abstract String localName();

    public abstract PipelineNode.PCollectionNode collection();

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Transform", (Object)this.transform().toString()).add("PCollection", (Object)this.collection().toString()).toString();
    }
}

