/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Query;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.VertexQuery;
import com.tinkerpop.blueprints.util.DefaultQuery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DefaultVertexQuery
extends DefaultQuery
implements VertexQuery {
    protected final Vertex vertex;

    public DefaultVertexQuery(Vertex vertex) {
        this.vertex = vertex;
    }

    @Override
    public VertexQuery has(String key) {
        super.has(key);
        return this;
    }

    @Override
    public VertexQuery hasNot(String key) {
        super.hasNot(key);
        return this;
    }

    @Override
    public VertexQuery has(String key, Object value) {
        super.has(key, value);
        return this;
    }

    @Override
    public VertexQuery hasNot(String key, Object value) {
        super.hasNot(key, value);
        return this;
    }

    @Override
    public VertexQuery has(String key, Predicate predicate, Object value) {
        super.has(key, predicate, value);
        return this;
    }

    @Override
    public <T extends Comparable<T>> VertexQuery has(String key, T value, Query.Compare compare) {
        super.has(key, compare, value);
        return this;
    }

    @Override
    public <T extends Comparable<?>> VertexQuery interval(String key, T startValue, T endValue) {
        super.interval(key, startValue, endValue);
        return this;
    }

    @Override
    public VertexQuery limit(int limit) {
        super.limit(limit);
        return this;
    }

    @Override
    public VertexQuery direction(Direction direction) {
        this.direction = direction;
        return this;
    }

    @Override
    public VertexQuery labels(String ... labels) {
        this.labels = labels;
        return this;
    }

    @Override
    public Iterable<Edge> edges() {
        return new DefaultVertexQueryIterable<Edge>(false);
    }

    @Override
    public Iterable<Vertex> vertices() {
        return new DefaultVertexQueryIterable<Vertex>(true);
    }

    @Override
    public long count() {
        long count = 0L;
        for (Edge edge : this.edges()) {
            ++count;
        }
        return count;
    }

    @Override
    public Object vertexIds() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Vertex vertex : this.vertices()) {
            list.add(vertex.getId());
        }
        return list;
    }

    private class DefaultVertexQueryIterable<T extends Element>
    implements Iterable<T> {
        private Iterable<Edge> iterable;
        private boolean forVertex;

        public DefaultVertexQueryIterable(boolean forVertex) {
            this.forVertex = forVertex;
            this.iterable = DefaultVertexQuery.this.vertex.getEdges(DefaultVertexQuery.this.direction, DefaultVertexQuery.this.labels);
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                Edge nextEdge = null;
                final Iterator<Edge> itty = DefaultVertexQueryIterable.access$000(DefaultVertexQueryIterable.this).iterator();
                long count = 0L;

                @Override
                public boolean hasNext() {
                    if (null != this.nextEdge) {
                        return true;
                    }
                    return this.loadNext();
                }

                @Override
                public T next() {
                    do {
                        if (this.nextEdge == null) continue;
                        Edge temp = this.nextEdge;
                        this.nextEdge = null;
                        if (DefaultVertexQueryIterable.this.forVertex) {
                            if (DefaultVertexQuery.this.direction == Direction.OUT) {
                                return temp.getVertex(Direction.IN);
                            }
                            if (DefaultVertexQuery.this.direction == Direction.IN) {
                                return temp.getVertex(Direction.OUT);
                            }
                            if (temp.getVertex(Direction.OUT).equals(DefaultVertexQuery.this.vertex)) {
                                return temp.getVertex(Direction.IN);
                            }
                            return temp.getVertex(Direction.OUT);
                        }
                        return temp;
                    } while (this.loadNext());
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private boolean loadNext() {
                    this.nextEdge = null;
                    if (this.count > (long)DefaultVertexQuery.this.limit) {
                        return false;
                    }
                    while (this.itty.hasNext()) {
                        Edge edge = this.itty.next();
                        boolean filter = false;
                        for (DefaultQuery.HasContainer hasContainer : DefaultVertexQuery.this.hasContainers) {
                            if (hasContainer.isLegal(edge)) continue;
                            filter = true;
                            break;
                        }
                        if (filter || ++this.count > (long)DefaultVertexQuery.this.limit) continue;
                        this.nextEdge = edge;
                        return true;
                    }
                    return false;
                }
            };
        }

        static /* synthetic */ Iterable access$000(DefaultVertexQueryIterable x0) {
            return x0.iterable;
        }
    }
}

