/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fake;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.fake.FakeField;
import org.apache.hop.pipeline.transforms.fake.FakeMeta;
import org.apache.hop.pipeline.transforms.fake.FakerType;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FakeDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = FakeDialog.class;
    private TableView wFields;
    private ComboVar wLocale;
    private final FakeMeta input;

    public FakeDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (FakeMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FakeDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        FakeDialog fakeDialog = this;
        int margin = fakeDialog.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlLocale = new Label((Composite)this.shell, 131072);
        wlLocale.setText(BaseMessages.getString(PKG, (String)"FakeDialog.Label.Locale", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLocale);
        FormData fdlLocale = new FormData();
        fdlLocale.left = new FormAttachment(0, 0);
        fdlLocale.right = new FormAttachment(middle, -margin);
        fdlLocale.top = new FormAttachment((Control)this.wTransformName, margin);
        wlLocale.setLayoutData((Object)fdlLocale);
        this.wLocale = new ComboVar(this.variables, (Composite)this.shell, 18436);
        this.wLocale.setItems(FakeMeta.getFakerLocales());
        this.wLocale.setText(this.transformName);
        PropsUi.setLook((Widget)this.wLocale);
        this.wLocale.addModifyListener(lsMod);
        FormData fdLocale = new FormData();
        fdLocale.left = new FormAttachment(middle, 0);
        fdLocale.top = new FormAttachment((Control)wlLocale, 0, 0x1000000);
        fdLocale.right = new FormAttachment(100, 0);
        this.wLocale.setLayoutData((Object)fdLocale);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"FakeDialog.Name.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FakeDialog.Type.Column", (String[])new String[0]), 2, new String[0]), new ColumnInfo(BaseMessages.getString(PKG, (String)"FakeDialog.Topic.Column", (String[])new String[0]), 2, new String[0])};
        columns[1].setComboValuesSelectionListener(this::getComboValues);
        columns[2].setComboValuesSelectionListener(this::getComboValues);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, columns, this.input.getFields().size(), lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wLocale, 2 * margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.lsResize = event -> {
            Point size = this.shell.getSize();
            this.wFields.setSize(size.x - 10, size.y - 50);
            this.wFields.table.setSize(size.x - 10, size.y - 50);
            this.wFields.redraw();
        };
        this.shell.addListener(11, this.lsResize);
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private String[] getComboValues(TableItem tableItem, int rowNr, int colNr) {
        String typeDescription;
        FakerType fakerType;
        if (colNr == 2) {
            return FakerType.getTypeDescriptions();
        }
        if (colNr == 3 && (fakerType = FakerType.getTypeUsingDescription(typeDescription = tableItem.getText(2))) != null) {
            return this.getMethodNames(fakerType);
        }
        return new String[0];
    }

    public String[] getMethodNames(FakerType fakerType) {
        try {
            Method[] methods = fakerType.getFakerClass().getDeclaredMethods();
            String[] names = new String[methods.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = methods[i].getName();
            }
            return names;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public void getData() {
        this.wLocale.setText(Const.NVL((String)this.input.getLocale(), (String)""));
        for (int row = 0; row < this.input.getFields().size(); ++row) {
            FakeField fakeField = this.input.getFields().get(row);
            TableItem item = this.wFields.table.getItem(row);
            int col = 1;
            item.setText(col++, Const.NVL((String)fakeField.getName(), (String)""));
            item.setText(col++, Const.NVL((String)fakeField.getType(), (String)""));
            item.setText(col, Const.NVL((String)fakeField.getTopic(), (String)""));
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(FakeMeta meta) {
        meta.setLocale(this.wLocale.getText());
        meta.getFields().clear();
        List nonEmptyItems = this.wFields.getNonEmptyItems();
        for (TableItem tableItem : nonEmptyItems) {
            int col = 1;
            String name = tableItem.getText(col++);
            String typeDesc = tableItem.getText(col++);
            String topic = tableItem.getText(col);
            FakerType fakerType = FakerType.getTypeUsingDescription(typeDesc);
            if (fakerType == null) {
                fakerType = FakerType.getTypeUsingName(typeDesc);
            }
            if (fakerType == null) continue;
            meta.getFields().add(new FakeField(name, fakerType.name(), topic));
        }
    }
}

