/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.checksum;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.spark.annotation.Private;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.shuffle.checksum.Cause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.guava.io.ByteStreams;

@Private
public class ShuffleChecksumHelper {
    private static final Logger logger = LoggerFactory.getLogger(ShuffleChecksumHelper.class);
    public static final int CHECKSUM_CALCULATION_BUFFER = 8192;
    public static final Checksum[] EMPTY_CHECKSUM = new Checksum[0];
    public static final long[] EMPTY_CHECKSUM_VALUE = new long[0];

    public static Checksum[] createPartitionChecksums(int numPartitions, String algorithm) {
        return ShuffleChecksumHelper.getChecksumsByAlgorithm(numPartitions, algorithm);
    }

    private static Checksum[] getChecksumsByAlgorithm(int num, String algorithm) {
        switch (algorithm) {
            case "ADLER32": {
                Checksum[] checksums = new Adler32[num];
                for (int i = 0; i < num; ++i) {
                    checksums[i] = new Adler32();
                }
                return checksums;
            }
            case "CRC32": {
                Checksum[] checksums = new CRC32[num];
                for (int i = 0; i < num; ++i) {
                    checksums[i] = new CRC32();
                }
                return checksums;
            }
        }
        throw new UnsupportedOperationException("Unsupported shuffle checksum algorithm: " + algorithm);
    }

    public static Checksum getChecksumByAlgorithm(String algorithm) {
        return ShuffleChecksumHelper.getChecksumsByAlgorithm(1, algorithm)[0];
    }

    public static String getChecksumFileName(String blockName, String algorithm) {
        return String.format("%s.%s", blockName, algorithm);
    }

    private static long readChecksumByReduceId(File checksumFile, int reduceId) throws IOException {
        try (DataInputStream in = new DataInputStream(new FileInputStream(checksumFile));){
            ByteStreams.skipFully((InputStream)in, (long)((long)reduceId * 8L));
            long l = in.readLong();
            return l;
        }
    }

    private static long calculateChecksumForPartition(ManagedBuffer partitionData, Checksum checksumAlgo) throws IOException {
        InputStream in = partitionData.createInputStream();
        byte[] buffer = new byte[8192];
        try (CheckedInputStream checksumIn = new CheckedInputStream(in, checksumAlgo);){
            while (checksumIn.read(buffer, 0, 8192) != -1) {
            }
            long l = checksumAlgo.getValue();
            return l;
        }
    }

    public static Cause diagnoseCorruption(String algorithm, File checksumFile, int reduceId, ManagedBuffer partitionData, long checksumByReader) {
        Cause cause;
        try {
            long diagnoseStartNs = System.nanoTime();
            Checksum checksumAlgo = ShuffleChecksumHelper.getChecksumByAlgorithm(algorithm);
            long checksumByWriter = ShuffleChecksumHelper.readChecksumByReduceId(checksumFile, reduceId);
            long checksumByReCalculation = ShuffleChecksumHelper.calculateChecksumForPartition(partitionData, checksumAlgo);
            long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - diagnoseStartNs);
            logger.info("Shuffle corruption diagnosis took {} ms, checksum file {}", (Object)duration, (Object)checksumFile.getAbsolutePath());
            cause = checksumByWriter != checksumByReCalculation ? Cause.DISK_ISSUE : (checksumByWriter != checksumByReader ? Cause.NETWORK_ISSUE : Cause.CHECKSUM_VERIFY_PASS);
        }
        catch (UnsupportedOperationException e) {
            cause = Cause.UNSUPPORTED_CHECKSUM_ALGORITHM;
        }
        catch (FileNotFoundException e) {
            logger.warn("Checksum file " + checksumFile.getName() + " doesn't exit");
            cause = Cause.UNKNOWN_ISSUE;
        }
        catch (Exception e) {
            logger.warn("Unable to diagnose shuffle block corruption", (Throwable)e);
            cause = Cause.UNKNOWN_ISSUE;
        }
        return cause;
    }
}

