/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.beam.runners.fnexecution.control.DefaultExecutableStageContext;
import org.apache.beam.runners.fnexecution.control.ExecutableStageContext;
import org.apache.beam.runners.fnexecution.control.ReferenceCountingExecutableStageContextFactory;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.flink.api.java.ExecutionEnvironment;

public class FlinkExecutableStageContextFactory
implements ExecutableStageContext.Factory {
    private static final FlinkExecutableStageContextFactory instance = new FlinkExecutableStageContextFactory();
    private static final ConcurrentMap<String, ExecutableStageContext.Factory> jobFactories = new ConcurrentHashMap<String, ExecutableStageContext.Factory>();

    private FlinkExecutableStageContextFactory() {
    }

    public static FlinkExecutableStageContextFactory getInstance() {
        return instance;
    }

    public ExecutableStageContext get(JobInfo jobInfo) {
        ExecutableStageContext.Factory jobFactory = jobFactories.computeIfAbsent(jobInfo.jobId(), k -> ReferenceCountingExecutableStageContextFactory.create(DefaultExecutableStageContext::create, (SerializableFunction & Serializable)caller -> caller.getClass().getClassLoader() != ExecutionEnvironment.class.getClassLoader()));
        return jobFactory.get(jobInfo);
    }
}

