/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.common;

import java.util.Observable;
import java.util.Observer;
import org.apache.beam.sdk.annotations.Internal;

@Internal
public abstract class ElementByteSizeObserver
implements Observer {
    private boolean isLazy = false;
    private long totalSize = 0L;
    private double scalingFactor = 1.0;

    protected abstract void reportElementSize(long var1);

    public void setLazy() {
        this.isLazy = true;
    }

    public boolean getIsLazy() {
        return this.isLazy;
    }

    public void update(Object obj) {
        this.update(null, obj);
    }

    public void setScalingFactor(double scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    @Override
    public void update(Observable obs, Object obj) {
        if (obj instanceof Long) {
            this.totalSize += (long)(this.scalingFactor * (double)((Long)obj).longValue());
        } else if (obj instanceof Integer) {
            this.totalSize += (long)(this.scalingFactor * (double)((Integer)obj).intValue());
        } else {
            throw new AssertionError((Object)"unexpected parameter object");
        }
    }

    public void advance() {
        this.reportElementSize(this.totalSize);
        this.totalSize = 0L;
        this.isLazy = false;
    }
}

