/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.auto.value.AutoValue;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.beam.sdk.util.AutoValue_RowJsonValueExtractors_ValidatingValueExtractor;
import org.apache.beam.sdk.util.RowJson;
import org.joda.time.DateTime;

class RowJsonValueExtractors {
    RowJsonValueExtractors() {
    }

    static ValueExtractor<Byte> byteValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(jsonNode -> (byte)jsonNode.intValue()).setValidator(jsonNode -> jsonNode.isIntegralNumber() && jsonNode.canConvertToInt() && jsonNode.intValue() >= -128 && jsonNode.intValue() <= 127).build();
    }

    static ValueExtractor<Short> shortValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(jsonNode -> (short)jsonNode.intValue()).setValidator(jsonNode -> jsonNode.isIntegralNumber() && jsonNode.canConvertToInt() && jsonNode.intValue() >= Short.MIN_VALUE && jsonNode.intValue() <= Short.MAX_VALUE).build();
    }

    static ValueExtractor<Integer> intValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(JsonNode::intValue).setValidator(jsonNode -> jsonNode.isIntegralNumber() && jsonNode.canConvertToInt()).build();
    }

    static ValueExtractor<Long> longValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(JsonNode::longValue).setValidator(jsonNode -> jsonNode.isIntegralNumber() && jsonNode.canConvertToLong()).build();
    }

    static ValueExtractor<Float> floatValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(JsonNode::floatValue).setValidator(jsonNode -> jsonNode.isFloat() || jsonNode.isFloatingPointNumber() && jsonNode.doubleValue() == (double)((float)jsonNode.doubleValue()) || jsonNode.isIntegralNumber() && jsonNode.canConvertToInt() && jsonNode.asInt() == (int)((float)jsonNode.asInt())).build();
    }

    static ValueExtractor<Double> doubleValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(JsonNode::doubleValue).setValidator(jsonNode -> jsonNode.isDouble() || jsonNode.isIntegralNumber() && jsonNode.canConvertToLong() && jsonNode.asLong() == (long)((double)jsonNode.asInt()) || jsonNode.isFloatingPointNumber() && jsonNode.decimalValue().equals(BigDecimal.valueOf(jsonNode.doubleValue()))).build();
    }

    static ValueExtractor<Boolean> booleanValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(JsonNode::booleanValue).setValidator(JsonNode::isBoolean).build();
    }

    static ValueExtractor<String> stringValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(JsonNode::textValue).setValidator(JsonNode::isTextual).build();
    }

    static ValueExtractor<BigDecimal> decimalValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(JsonNode::decimalValue).setValidator(jsonNode -> jsonNode.isNumber()).build();
    }

    static ValueExtractor<DateTime> datetimeValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(jsonNode -> DateTime.parse((String)jsonNode.textValue())).setValidator(JsonNode::isTextual).build();
    }

    static ValueExtractor<LocalDate> dateValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(jsonNode -> LocalDate.parse(jsonNode.textValue())).setValidator(JsonNode::isTextual).build();
    }

    static ValueExtractor<LocalTime> timeValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(jsonNode -> LocalTime.parse(jsonNode.textValue())).setValidator(JsonNode::isTextual).build();
    }

    static ValueExtractor<LocalDateTime> localDatetimeValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(jsonNode -> LocalDateTime.parse(jsonNode.textValue())).setValidator(JsonNode::isTextual).build();
    }

    @AutoValue
    public static abstract class ValidatingValueExtractor<W>
    implements ValueExtractor<W> {
        abstract Predicate<JsonNode> validator();

        abstract Function<JsonNode, W> extractor();

        static <T> Builder<T> builder() {
            return new AutoValue_RowJsonValueExtractors_ValidatingValueExtractor.Builder();
        }

        @Override
        public W extractValue(JsonNode value) {
            if (!this.validator().test(value)) {
                throw new RowJson.UnsupportedRowJsonException("Value \"" + value.asText() + "\" is out of range for the type of the field defined in the row schema.");
            }
            return this.extractor().apply(value);
        }

        @AutoValue.Builder
        static abstract class Builder<W> {
            Builder() {
            }

            abstract Builder<W> setValidator(Predicate<JsonNode> var1);

            abstract Builder<W> setExtractor(Function<JsonNode, W> var1);

            abstract ValidatingValueExtractor<W> build();
        }
    }

    public static interface ValueExtractor<V> {
        public V extractValue(JsonNode var1);
    }
}

