/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.NonMergingWindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

public class SlidingWindows
extends NonMergingWindowFn<Object, IntervalWindow> {
    private final Duration period;
    private final Duration size;
    private final Duration offset;

    public static SlidingWindows of(Duration size) {
        return new SlidingWindows(SlidingWindows.getDefaultPeriod(size), size, Duration.ZERO);
    }

    public SlidingWindows every(Duration period) {
        return new SlidingWindows(period, this.size, this.offset);
    }

    public SlidingWindows withOffset(Duration offset) {
        return new SlidingWindows(this.period, this.size, offset);
    }

    private SlidingWindows(Duration period, Duration size, Duration offset) {
        if (offset.isShorterThan((ReadableDuration)Duration.ZERO) || !offset.isShorterThan((ReadableDuration)period) || !size.isLongerThan((ReadableDuration)Duration.ZERO)) {
            throw new IllegalArgumentException("SlidingWindows WindowingStrategies must have 0 <= offset < period and 0 < size");
        }
        this.period = period;
        this.size = size;
        this.offset = offset;
    }

    @Override
    public Coder<IntervalWindow> windowCoder() {
        return IntervalWindow.getCoder();
    }

    @Override
    public Collection<IntervalWindow> assignWindows(WindowFn.AssignContext c) {
        return this.assignWindows(c.timestamp());
    }

    public Collection<IntervalWindow> assignWindows(Instant timestamp) {
        long lastStart;
        ArrayList<IntervalWindow> windows = new ArrayList<IntervalWindow>((int)(this.size.getMillis() / this.period.getMillis()));
        for (long start = lastStart = this.lastStartFor(timestamp); start > timestamp.minus((ReadableDuration)this.size).getMillis(); start -= this.period.getMillis()) {
            windows.add(new IntervalWindow(new Instant(start), (ReadableDuration)this.size));
        }
        return windows;
    }

    @Override
    public WindowMappingFn<IntervalWindow> getDefaultWindowMappingFn() {
        return new WindowMappingFn<IntervalWindow>(){

            @Override
            public IntervalWindow getSideInputWindow(BoundedWindow mainWindow) {
                if (mainWindow instanceof GlobalWindow) {
                    throw new IllegalArgumentException("Attempted to get side input window for GlobalWindow from non-global WindowFn");
                }
                long lastStart = SlidingWindows.this.lastStartFor(mainWindow.maxTimestamp().minus((ReadableDuration)SlidingWindows.this.size));
                return new IntervalWindow(new Instant(lastStart + SlidingWindows.this.period.getMillis()), (ReadableDuration)SlidingWindows.this.size);
            }
        };
    }

    @Override
    public boolean isCompatible(WindowFn<?, ?> other) {
        return this.equals(other);
    }

    @Override
    public boolean assignsToOneWindow() {
        return !this.period.isShorterThan((ReadableDuration)this.size);
    }

    @Override
    public void verifyCompatibility(WindowFn<?, ?> other) throws IncompatibleWindowException {
        if (!this.isCompatible(other)) {
            throw new IncompatibleWindowException(other, String.format("Only %s objects with the same size, period and offset are compatible.", SlidingWindows.class.getSimpleName()));
        }
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item("size", this.size).withLabel("Window Size")).add(DisplayData.item("period", this.period).withLabel("Window Period")).add(DisplayData.item("offset", this.offset).withLabel("Window Start Offset"));
    }

    private long lastStartFor(Instant timestamp) {
        return timestamp.getMillis() - timestamp.plus((ReadableDuration)this.period).minus((ReadableDuration)this.offset).getMillis() % this.period.getMillis();
    }

    static Duration getDefaultPeriod(Duration size) {
        if (size.isLongerThan((ReadableDuration)Duration.standardHours((long)1L))) {
            return Duration.standardHours((long)1L);
        }
        if (size.isLongerThan((ReadableDuration)Duration.standardMinutes((long)1L))) {
            return Duration.standardMinutes((long)1L);
        }
        if (size.isLongerThan((ReadableDuration)Duration.standardSeconds((long)1L))) {
            return Duration.standardSeconds((long)1L);
        }
        return Duration.millis((long)1L);
    }

    public Duration getPeriod() {
        return this.period;
    }

    public Duration getSize() {
        return this.size;
    }

    public Duration getOffset() {
        return this.offset;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof SlidingWindows)) {
            return false;
        }
        SlidingWindows other = (SlidingWindows)object;
        return this.getOffset().equals((Object)other.getOffset()) && this.getSize().equals((Object)other.getSize()) && this.getPeriod().equals((Object)other.getPeriod());
    }

    public int hashCode() {
        return Objects.hash(this.size, this.offset, this.period);
    }
}

