/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.splittabledofn;

import com.google.auto.value.AutoValue;
import org.apache.beam.sdk.transforms.splittabledofn.AutoValue_RestrictionTracker_Progress;
import org.apache.beam.sdk.transforms.splittabledofn.AutoValue_RestrictionTracker_TruncateResult;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class RestrictionTracker<RestrictionT, PositionT> {
    public abstract boolean tryClaim(PositionT var1);

    public abstract RestrictionT currentRestriction();

    public abstract @Nullable SplitResult<RestrictionT> trySplit(double var1);

    public abstract void checkDone() throws IllegalStateException;

    public abstract IsBounded isBounded();

    @AutoValue
    public static abstract class TruncateResult<RestrictionT> {
        public static <RestrictionT> TruncateResult of(RestrictionT restriction) {
            return new AutoValue_RestrictionTracker_TruncateResult<RestrictionT>(restriction);
        }

        public abstract @Nullable RestrictionT getTruncatedRestriction();
    }

    @AutoValue
    public static abstract class Progress {
        public static Progress from(double workCompleted, double workRemaining) {
            if (workCompleted < 0.0 || workRemaining < 0.0) {
                throw new IllegalArgumentException(String.format("Work completed and work remaining must be greater than or equal to zero but were %s and %s.", workCompleted, workRemaining));
            }
            return new AutoValue_RestrictionTracker_Progress(workCompleted, workRemaining);
        }

        public abstract double getWorkCompleted();

        public abstract double getWorkRemaining();
    }

    public static interface HasProgress {
        public Progress getProgress();
    }

    public static enum IsBounded {
        BOUNDED,
        UNBOUNDED;

    }
}

