/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableComparator;
import org.apache.beam.sdk.transforms.Top;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class Sample {
    public static <T> Combine.CombineFn<T, ?, Iterable<T>> combineFn(int sampleSize) {
        return new FixedSizedSampleFn(sampleSize);
    }

    public static <T> Combine.CombineFn<T, ?, Iterable<T>> anyCombineFn(int sampleSize) {
        return new SampleAnyCombineFn(sampleSize);
    }

    public static <T> Combine.CombineFn<T, ?, T> anyValueCombineFn() {
        return new AnyValueCombineFn();
    }

    public static <T> PTransform<PCollection<T>, PCollection<T>> any(long limit) {
        return new Any(limit);
    }

    public static <T> PTransform<PCollection<T>, PCollection<Iterable<T>>> fixedSizeGlobally(int sampleSize) {
        return new FixedSizeGlobally(sampleSize);
    }

    public static <K, V> PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> fixedSizePerKey(int sampleSize) {
        return new FixedSizePerKey(sampleSize);
    }

    public static class FixedSizedSampleFn<T>
    extends Combine.CombineFn<T, Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>>, Iterable<T>> {
        private final int sampleSize;
        private final Top.TopCombineFn<KV<Integer, T>, SerializableComparator<KV<Integer, T>>> topCombineFn;
        private final Random rand = new Random();

        private FixedSizedSampleFn(int sampleSize) {
            if (sampleSize < 0) {
                throw new IllegalArgumentException("sample size must be >= 0");
            }
            this.sampleSize = sampleSize;
            this.topCombineFn = new Top.TopCombineFn(sampleSize, new KV.OrderByKey());
        }

        @Override
        public Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>> createAccumulator() {
            return this.topCombineFn.createAccumulator();
        }

        @Override
        public Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>> addInput(Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>> accumulator, T input) {
            accumulator.addInput(KV.of(this.rand.nextInt(), input));
            return accumulator;
        }

        @Override
        public Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>> mergeAccumulators(Iterable<Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>>> accumulators) {
            return (Top.BoundedHeap)this.topCombineFn.mergeAccumulators(accumulators);
        }

        @Override
        public Iterable<T> extractOutput(Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>> accumulator) {
            ArrayList out = new ArrayList();
            Iterator iterator = accumulator.extractOutput().iterator();
            while (iterator.hasNext()) {
                KV element = (KV)iterator.next();
                out.add(element.getValue());
            }
            return out;
        }

        @Override
        public Coder<Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>>> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) {
            return this.topCombineFn.getAccumulatorCoder(registry, (Coder<KV<Integer, T>>)KvCoder.of(BigEndianIntegerCoder.of(), inputCoder));
        }

        @Override
        public Coder<Iterable<T>> getDefaultOutputCoder(CoderRegistry registry, Coder<T> inputCoder) {
            return IterableCoder.of(inputCoder);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("sampleSize", this.sampleSize).withLabel("Sample Size"));
        }
    }

    private static class AnyValueCombineFn<T>
    extends Combine.CombineFn<T, List<T>, T> {
        private SampleAnyCombineFn internal = new SampleAnyCombineFn(1L);

        private AnyValueCombineFn() {
        }

        @Override
        public List<T> createAccumulator() {
            return this.internal.createAccumulator();
        }

        @Override
        public List<T> addInput(List<T> accumulator, T input) {
            return this.internal.addInput(accumulator, input);
        }

        @Override
        public List<T> mergeAccumulators(Iterable<List<T>> accumulators) {
            return this.internal.mergeAccumulators((Iterable)accumulators);
        }

        @Override
        public T extractOutput(List<T> accumulator) {
            Iterator<T> it = this.internal.extractOutput(accumulator).iterator();
            return it.hasNext() ? (T)it.next() : null;
        }
    }

    private static class SampleAnyCombineFn<T>
    extends Combine.CombineFn<T, List<T>, Iterable<T>> {
        private final long limit;

        private SampleAnyCombineFn(long limit) {
            this.limit = limit;
        }

        @Override
        public List<T> createAccumulator() {
            return new ArrayList((int)this.limit);
        }

        @Override
        public List<T> addInput(List<T> accumulator, T input) {
            if ((long)accumulator.size() < this.limit) {
                accumulator.add(input);
            }
            return accumulator;
        }

        @Override
        public List<T> mergeAccumulators(Iterable<List<T>> accumulators) {
            Iterator<List<T>> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator();
            }
            List<T> res = iter.next();
            while (iter.hasNext()) {
                for (T t : iter.next()) {
                    if ((long)res.size() >= this.limit) {
                        return res;
                    }
                    res.add(t);
                }
            }
            return res;
        }

        @Override
        public Iterable<T> extractOutput(List<T> accumulator) {
            return accumulator;
        }
    }

    private static class FixedSizePerKey<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
        private final int sampleSize;

        private FixedSizePerKey(int sampleSize) {
            this.sampleSize = sampleSize;
        }

        @Override
        public PCollection<KV<K, Iterable<V>>> expand(PCollection<KV<K, V>> input) {
            return (PCollection)input.apply(Combine.perKey(new FixedSizedSampleFn(this.sampleSize)));
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("sampleSize", this.sampleSize).withLabel("Sample Size"));
        }
    }

    private static class FixedSizeGlobally<T>
    extends PTransform<PCollection<T>, PCollection<Iterable<T>>> {
        private final int sampleSize;

        private FixedSizeGlobally(int sampleSize) {
            this.sampleSize = sampleSize;
        }

        @Override
        public PCollection<Iterable<T>> expand(PCollection<T> input) {
            return (PCollection)input.apply(Combine.globally(new FixedSizedSampleFn(this.sampleSize)));
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("sampleSize", this.sampleSize).withLabel("Sample Size"));
        }
    }

    private static class Any<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final long limit;

        private Any(long limit) {
            Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (String)"Expected non-negative limit, received %s.", (long)limit);
            this.limit = limit;
        }

        @Override
        public PCollection<T> expand(PCollection<T> in) {
            return (PCollection)((PCollection)in.apply(Combine.globally(new SampleAnyCombineFn(this.limit)).withoutDefaults())).apply(Flatten.iterables());
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("sampleSize", this.limit).withLabel("Sample Size"));
        }
    }
}

