/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;

@Experimental(value=Experimental.Kind.CONTEXTFUL)
public final class Requirements
implements Serializable {
    private final Collection<PCollectionView<?>> sideInputs;

    private Requirements(Collection<PCollectionView<?>> sideInputs) {
        this.sideInputs = sideInputs;
    }

    public Collection<PCollectionView<?>> getSideInputs() {
        return this.sideInputs;
    }

    public static Requirements requiresSideInputs(Collection<PCollectionView<?>> sideInputs) {
        return new Requirements(sideInputs);
    }

    public static Requirements requiresSideInputs(PCollectionView<?> ... sideInputs) {
        return Requirements.requiresSideInputs(Arrays.asList(sideInputs));
    }

    public static Requirements empty() {
        return new Requirements(Collections.emptyList());
    }

    public boolean isEmpty() {
        return this.sideInputs.isEmpty();
    }

    public static Requirements union(Contextful ... contextfuls) {
        HashSet sideInputs = Sets.newHashSet();
        for (Contextful c : contextfuls) {
            sideInputs.addAll(c.getRequirements().getSideInputs());
        }
        return Requirements.requiresSideInputs(sideInputs);
    }
}

