/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.InferableFunction;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.WithFailures;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FlatMapElements<InputT, OutputT>
extends PTransform<PCollection<? extends InputT>, PCollection<OutputT>> {
    private final transient @Nullable TypeDescriptor<InputT> inputType;
    private final transient @Nullable TypeDescriptor<OutputT> outputType;
    private final transient @Nullable Object originalFnForDisplayData;
    private final @Nullable Contextful<Contextful.Fn<InputT, Iterable<OutputT>>> fn;

    private FlatMapElements(@Nullable Contextful<Contextful.Fn<InputT, Iterable<OutputT>>> fn, @Nullable Object originalFnForDisplayData, @Nullable TypeDescriptor<InputT> inputType, TypeDescriptor<OutputT> outputType) {
        this.fn = fn;
        this.originalFnForDisplayData = originalFnForDisplayData;
        this.inputType = inputType;
        this.outputType = outputType;
    }

    public static <InputT, OutputT> FlatMapElements<InputT, OutputT> via(InferableFunction<? super InputT, ? extends Iterable<OutputT>> fn) {
        Contextful<Contextful.Fn<InputT, Iterable<OutputT>>> wrapped = Contextful.fn(fn);
        TypeDescriptor outputType = TypeDescriptors.extractFromTypeParameters(fn.getOutputTypeDescriptor(), Iterable.class, new TypeDescriptors.TypeVariableExtractor<Iterable<OutputT>, OutputT>(){});
        TypeDescriptor<? super InputT> inputType = fn.getInputTypeDescriptor();
        return new FlatMapElements<InputT, OutputT>(wrapped, fn, inputType, outputType);
    }

    public static <InputT, OutputT> FlatMapElements<InputT, OutputT> via(SimpleFunction<? super InputT, ? extends Iterable<OutputT>> fn) {
        return FlatMapElements.via(fn);
    }

    public static <OutputT> FlatMapElements<?, OutputT> into(TypeDescriptor<OutputT> outputType) {
        return new FlatMapElements(null, null, null, outputType);
    }

    public <NewInputT> FlatMapElements<NewInputT, OutputT> via(ProcessFunction<NewInputT, ? extends Iterable<OutputT>> fn) {
        return new FlatMapElements<InputT, OutputT>(Contextful.fn(fn), fn, TypeDescriptors.inputOf(fn), this.outputType);
    }

    public <NewInputT> FlatMapElements<NewInputT, OutputT> via(SerializableFunction<NewInputT, ? extends Iterable<OutputT>> fn) {
        return this.via((ProcessFunction<NewInputT, ? extends Iterable<OutputT>>)fn);
    }

    @Experimental(value=Experimental.Kind.CONTEXTFUL)
    public <NewInputT> FlatMapElements<NewInputT, OutputT> via(Contextful<Contextful.Fn<NewInputT, Iterable<OutputT>>> fn) {
        return new FlatMapElements<InputT, OutputT>(fn, fn.getClosure(), TypeDescriptors.inputOf(fn.getClosure()), this.outputType);
    }

    @Override
    public PCollection<OutputT> expand(PCollection<? extends InputT> input) {
        Preconditions.checkArgument((this.fn != null ? 1 : 0) != 0, (Object)".via() is required");
        return (PCollection)input.apply("FlatMap", ParDo.of(new DoFn<InputT, OutputT>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                Iterable res = (Iterable)((Contextful.Fn)FlatMapElements.this.fn.getClosure()).apply(c.element(), Contextful.Fn.Context.wrapProcessContext(c));
                for (Object output : res) {
                    c.output(output);
                }
            }

            @Override
            public TypeDescriptor<InputT> getInputTypeDescriptor() {
                return FlatMapElements.this.inputType;
            }

            @Override
            public TypeDescriptor<OutputT> getOutputTypeDescriptor() {
                Preconditions.checkState((FlatMapElements.this.outputType != null ? 1 : 0) != 0, (String)"%s output type descriptor was null; this probably means that getOutputTypeDescriptor() was called after serialization/deserialization, but it is only available prior to serialization, for constructing a pipeline and inferring coders", (Object)FlatMapElements.class.getSimpleName());
                return FlatMapElements.this.outputType;
            }

            @Override
            public void populateDisplayData(DisplayData.Builder builder) {
                builder.delegate(FlatMapElements.this);
            }
        }).withSideInputs(this.fn.getRequirements().getSideInputs()));
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item("class", this.originalFnForDisplayData.getClass()));
        if (this.originalFnForDisplayData instanceof HasDisplayData) {
            builder.include("fn", (HasDisplayData)this.originalFnForDisplayData);
        }
    }

    @Experimental(value=Experimental.Kind.WITH_EXCEPTIONS)
    public <NewFailureT> FlatMapWithFailures<InputT, OutputT, NewFailureT> exceptionsInto(TypeDescriptor<NewFailureT> failureTypeDescriptor) {
        return new FlatMapWithFailures<InputT, OutputT, NewFailureT>(this.fn, this.originalFnForDisplayData, this.inputType, this.outputType, null, failureTypeDescriptor);
    }

    @Experimental(value=Experimental.Kind.WITH_EXCEPTIONS)
    public <FailureT> FlatMapWithFailures<InputT, OutputT, FailureT> exceptionsVia(InferableFunction<WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler) {
        return new FlatMapWithFailures<InputT, OutputT, FailureT>(this.fn, this.originalFnForDisplayData, this.inputType, this.outputType, exceptionHandler, exceptionHandler.getOutputTypeDescriptor());
    }

    @Experimental(value=Experimental.Kind.WITH_EXCEPTIONS)
    public static class FlatMapWithFailures<InputT, OutputT, FailureT>
    extends PTransform<PCollection<InputT>, WithFailures.Result<PCollection<OutputT>, FailureT>> {
        private final transient TypeDescriptor<InputT> inputType;
        private final transient TypeDescriptor<OutputT> outputType;
        private final transient @Nullable TypeDescriptor<FailureT> failureType;
        private final transient Object originalFnForDisplayData;
        private final @Nullable Contextful<Contextful.Fn<InputT, Iterable<OutputT>>> fn;
        private final @Nullable ProcessFunction<WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler;

        FlatMapWithFailures(@Nullable Contextful<Contextful.Fn<InputT, Iterable<OutputT>>> fn, Object originalFnForDisplayData, TypeDescriptor<InputT> inputType, TypeDescriptor<OutputT> outputType, @Nullable ProcessFunction<WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler, @Nullable TypeDescriptor<FailureT> failureType) {
            this.fn = fn;
            this.originalFnForDisplayData = originalFnForDisplayData;
            this.inputType = inputType;
            this.outputType = outputType;
            this.exceptionHandler = exceptionHandler;
            this.failureType = failureType;
        }

        public FlatMapWithFailures<InputT, OutputT, FailureT> exceptionsVia(ProcessFunction<WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler) {
            return new FlatMapWithFailures<InputT, OutputT, FailureT>(this.fn, this.originalFnForDisplayData, this.inputType, this.outputType, exceptionHandler, this.failureType);
        }

        @Override
        public WithFailures.Result<PCollection<OutputT>, FailureT> expand(PCollection<InputT> input) {
            Preconditions.checkArgument((this.exceptionHandler != null ? 1 : 0) != 0, (Object)".exceptionsVia() is required");
            MapFn doFn = new MapFn();
            PCollectionTuple tuple = (PCollectionTuple)input.apply(FlatMapWithFailures.class.getSimpleName(), ParDo.of(doFn).withOutputTags(doFn.outputTag, TupleTagList.of(doFn.failureTag)).withSideInputs(this.fn.getRequirements().getSideInputs()));
            return WithFailures.Result.of(tuple, doFn.outputTag, doFn.failureTag);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("class", this.originalFnForDisplayData.getClass()));
            if (this.originalFnForDisplayData instanceof HasDisplayData) {
                builder.include("fn", (HasDisplayData)this.originalFnForDisplayData);
            }
            builder.add(DisplayData.item("exceptionHandler.class", this.exceptionHandler.getClass()));
            if (this.exceptionHandler instanceof HasDisplayData) {
                builder.include("exceptionHandler", (HasDisplayData)((Object)this.exceptionHandler));
            }
        }

        private class MapFn
        extends DoFn<InputT, OutputT> {
            final TupleTag<OutputT> outputTag = new TupleTag<OutputT>(){};
            final TupleTag<FailureT> failureTag = new FailureTag();

            private MapFn() {
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element InputT element, DoFn.MultiOutputReceiver r, DoFn.ProcessContext c) throws Exception {
                boolean exceptionWasThrown = false;
                Iterable res = null;
                try {
                    res = (Iterable)((Contextful.Fn)FlatMapWithFailures.this.fn.getClosure()).apply(c.element(), Contextful.Fn.Context.wrapProcessContext(c));
                }
                catch (Exception e) {
                    exceptionWasThrown = true;
                    WithFailures.ExceptionElement exceptionElement = WithFailures.ExceptionElement.of(element, e);
                    r.get(this.failureTag).output(FlatMapWithFailures.this.exceptionHandler.apply(exceptionElement));
                }
                if (!exceptionWasThrown) {
                    for (Object output : res) {
                        r.get(this.outputTag).output(output);
                    }
                }
            }

            @Override
            public void populateDisplayData(DisplayData.Builder builder) {
                builder.delegate(FlatMapWithFailures.this);
            }

            @Override
            public TypeDescriptor<InputT> getInputTypeDescriptor() {
                return FlatMapWithFailures.this.inputType;
            }

            @Override
            public TypeDescriptor<OutputT> getOutputTypeDescriptor() {
                Preconditions.checkState((FlatMapWithFailures.this.outputType != null ? 1 : 0) != 0, (String)"%s output type descriptor was null; this probably means that getOutputTypeDescriptor() was called after serialization/deserialization, but it is only available prior to serialization, for constructing a pipeline and inferring coders", (Object)FlatMapWithFailures.class.getSimpleName());
                return FlatMapWithFailures.this.outputType;
            }
        }

        private class FailureTag
        extends TupleTag<FailureT> {
            private FailureTag() {
            }

            @Override
            public TypeDescriptor<FailureT> getTypeDescriptor() {
                return FlatMapWithFailures.this.failureType;
            }
        }
    }
}

