/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.value.AutoValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import org.apache.beam.sdk.io.AutoValue_TextRowCountEstimator;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.CompressedSource;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.TextSource;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
public abstract class TextRowCountEstimator {
    private static final long DEFAULT_NUM_BYTES_PER_FILE = 65536L;
    private static final Compression DEFAULT_COMPRESSION = Compression.AUTO;
    private static final FileIO.ReadMatches.DirectoryTreatment DEFAULT_DIRECTORY_TREATMENT = FileIO.ReadMatches.DirectoryTreatment.SKIP;
    private static final EmptyMatchTreatment DEFAULT_EMPTY_MATCH_TREATMENT = EmptyMatchTreatment.DISALLOW;
    private static final SamplingStrategy DEFAULT_SAMPLING_STRATEGY = new SampleAllFiles();

    public abstract long getNumSampledBytesPerFile();

    public abstract byte @Nullable [] getDelimiters();

    public abstract String getFilePattern();

    public abstract Compression getCompression();

    public abstract SamplingStrategy getSamplingStrategy();

    public abstract EmptyMatchTreatment getEmptyMatchTreatment();

    public abstract FileIO.ReadMatches.DirectoryTreatment getDirectoryTreatment();

    public static Builder builder() {
        return new AutoValue_TextRowCountEstimator.Builder().setSamplingStrategy(DEFAULT_SAMPLING_STRATEGY).setNumSampledBytesPerFile(65536L).setCompression(DEFAULT_COMPRESSION).setDirectoryTreatment(DEFAULT_DIRECTORY_TREATMENT).setEmptyMatchTreatment(DEFAULT_EMPTY_MATCH_TREATMENT);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="https://github.com/spotbugs/spotbugs/issues/756")
    public Double estimateRowCount(PipelineOptions pipelineOptions) throws IOException, NoEstimationException {
        long linesSize = 0L;
        int numberOfReadLines = 0;
        long totalFileSizes = 0L;
        long totalSampledBytes = 0L;
        int numberOfReadFiles = 0;
        boolean sampledEverything = true;
        MatchResult match = FileSystems.match(this.getFilePattern(), this.getEmptyMatchTreatment());
        for (MatchResult.Metadata metadata : match.metadata()) {
            if (this.getSamplingStrategy().stopSampling(numberOfReadFiles, totalSampledBytes)) {
                sampledEverything = false;
                break;
            }
            if (FileIO.ReadMatches.shouldSkipDirectory(metadata, this.getDirectoryTreatment())) continue;
            FileIO.ReadableFile file = FileIO.ReadMatches.matchToReadableFile(metadata, this.getCompression());
            long readingWindowSize = Math.min(this.getNumSampledBytesPerFile(), metadata.sizeBytes());
            sampledEverything = metadata.sizeBytes() == readingWindowSize && sampledEverything;
            OffsetRange range = new OffsetRange(0L, readingWindowSize);
            TextSource textSource = new TextSource(ValueProvider.StaticValueProvider.of(file.getMetadata().resourceId().toString()), this.getEmptyMatchTreatment(), this.getDelimiters());
            CompressedSource<String> source = CompressedSource.from(textSource).withCompression(file.getCompression());
            try (BoundedSource.BoundedReader reader = ((FileBasedSource)source).createForSubrangeOfFile(file.getMetadata(), range.getFrom(), range.getTo()).createReader(pipelineOptions);){
                int numberOfNonEmptyLines = 0;
                boolean more = reader.start();
                while (more) {
                    numberOfNonEmptyLines += ((String)reader.getCurrent()).trim().equals("") ? 0 : 1;
                    more = reader.advance();
                }
                numberOfReadLines += numberOfNonEmptyLines;
                linesSize += numberOfNonEmptyLines == 0 ? 0L : readingWindowSize;
            }
            long fileSize = metadata.sizeBytes();
            numberOfReadFiles += fileSize == 0L ? 0 : 1;
            totalFileSizes += fileSize;
        }
        if (numberOfReadLines == 0 && sampledEverything) {
            return 0.0;
        }
        if (numberOfReadLines == 0) {
            throw new NoEstimationException("Cannot estimate the row count. All the sampled lines are empty");
        }
        return (double)totalFileSizes * (double)numberOfReadLines / (double)linesSize;
    }

    public static class LimitNumberOfTotalBytes
    implements SamplingStrategy {
        long limit;

        public LimitNumberOfTotalBytes(long limit) {
            this.limit = limit;
        }

        @Override
        public boolean stopSampling(int numberOfFiles, long totalReadBytes) {
            return totalReadBytes > this.limit;
        }
    }

    public static class LimitNumberOfFiles
    implements SamplingStrategy {
        int limit;

        public LimitNumberOfFiles(int limit) {
            this.limit = limit;
        }

        @Override
        public boolean stopSampling(int numberOfFiles, long totalReadBytes) {
            return numberOfFiles > this.limit;
        }
    }

    public static class SampleAllFiles
    implements SamplingStrategy {
        @Override
        public boolean stopSampling(int numberOfSampledFiles, long totalReadBytes) {
            return false;
        }
    }

    public static interface SamplingStrategy {
        public boolean stopSampling(int var1, long var2);
    }

    public static class NoEstimationException
    extends Exception {
        NoEstimationException(String message) {
            super(message);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setNumSampledBytesPerFile(long var1);

        public abstract Builder setDirectoryTreatment(FileIO.ReadMatches.DirectoryTreatment var1);

        public abstract Builder setCompression(Compression var1);

        public abstract Builder setDelimiters(byte @Nullable [] var1);

        public abstract Builder setFilePattern(String var1);

        public abstract Builder setEmptyMatchTreatment(EmptyMatchTreatment var1);

        public abstract Builder setSamplingStrategy(SamplingStrategy var1);

        public abstract TextRowCountEstimator build();
    }
}

