/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;

public class FileSystemUtils {
    @VisibleForTesting
    public static String wildcardToRegexp(String globExp) {
        StringBuilder dst = new StringBuilder();
        char[] src = globExp.replace("**/*", "**").toCharArray();
        int i = 0;
        block6: while (i < src.length) {
            char c = src[i++];
            switch (c) {
                case '*': {
                    if (i < src.length && src[i] == '*') {
                        dst.append(".*");
                        ++i;
                        continue block6;
                    }
                    dst.append("[^/]*");
                    continue block6;
                }
                case '?': {
                    dst.append("[^/]");
                    continue block6;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    dst.append('\\').append(c);
                    continue block6;
                }
                case '\\': {
                    i = FileSystemUtils.doubleSlashes(dst, src, i);
                    continue block6;
                }
            }
            dst.append(c);
        }
        return dst.toString();
    }

    private static int doubleSlashes(StringBuilder dst, char[] src, int i) {
        dst.append('\\');
        if (i + 1 < src.length) {
            dst.append('\\');
            dst.append(src[i]);
            ++i;
        } else {
            dst.append('\\');
        }
        return i;
    }
}

