/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BitConverters;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.joda.time.Instant;

public class InstantCoder
extends AtomicCoder<Instant> {
    private static final InstantCoder INSTANCE = new InstantCoder();
    private static final TypeDescriptor<Instant> TYPE_DESCRIPTOR = new TypeDescriptor<Instant>(){};

    public static InstantCoder of() {
        return INSTANCE;
    }

    private InstantCoder() {
    }

    @Override
    public void encode(Instant value, OutputStream outStream) throws CoderException, IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null Instant");
        }
        long shiftedMillis = value.getMillis() - Long.MIN_VALUE;
        BitConverters.writeBigEndianLong(shiftedMillis, outStream);
    }

    @Override
    public Instant decode(InputStream inStream) throws CoderException, IOException {
        long shiftedMillis;
        try {
            shiftedMillis = BitConverters.readBigEndianLong(inStream);
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
        return new Instant(shiftedMillis + Long.MIN_VALUE);
    }

    @Override
    public void verifyDeterministic() {
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Instant value) {
        return true;
    }

    @Override
    protected long getEncodedElementByteSize(Instant value) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Instant");
        }
        return 8L;
    }

    @Override
    public TypeDescriptor<Instant> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }
}

