/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public final class CoderProviders {
    private CoderProviders() {
    }

    public static CoderProvider fromStaticMethods(Class<?> rawType, Class<?> coderClazz) {
        Preconditions.checkArgument((boolean)Coder.class.isAssignableFrom(coderClazz), (String)"%s is not a subtype of %s", (Object)coderClazz.getName(), (Object)Coder.class.getSimpleName());
        return new CoderProviderFromStaticMethods(rawType, coderClazz);
    }

    public static CoderProvider forCoder(TypeDescriptor<?> type, Coder<?> coder) {
        return new CoderProviderForCoder(type, coder);
    }

    private static class CoderProviderForCoder
    extends CoderProvider {
        private final Coder<?> coder;
        private final TypeDescriptor<?> type;

        public CoderProviderForCoder(TypeDescriptor<?> type, Coder<?> coder) {
            this.type = type;
            this.coder = coder;
        }

        @Override
        public <T> Coder<T> coderFor(TypeDescriptor<T> type, List<? extends Coder<?>> componentCoders) throws CannotProvideCoderException {
            if (!this.type.equals(type)) {
                throw new CannotProvideCoderException(String.format("Unable to provide coder for %s, this factory can only provide coders for %s", type, this.type));
            }
            return this.coder;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("type", this.type).add("coder", this.coder).toString();
        }
    }

    private static class CoderProviderFromStaticMethods
    extends CoderProvider {
        private final Class<?> rawType;
        private final Method factoryMethod;

        @Override
        public <T> Coder<T> coderFor(TypeDescriptor<T> type, List<? extends Coder<?>> componentCoders) throws CannotProvideCoderException {
            if (!this.rawType.equals(type.getRawType())) {
                throw new CannotProvideCoderException(String.format("Unable to provide coder for %s, this factory can only provide coders for %s", type, this.rawType));
            }
            try {
                return (Coder)org.apache.beam.sdk.util.Preconditions.checkStateNotNull(this.factoryMethod.invoke(this.rawType, componentCoders.toArray()));
            }
            catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException exn) {
                throw new IllegalStateException("error when invoking Coder factory method " + this.factoryMethod, exn);
            }
        }

        private CoderProviderFromStaticMethods(Class<?> rawType, Class<?> coderClazz) {
            this.rawType = rawType;
            this.factoryMethod = CoderProviderFromStaticMethods.getFactoryMethod(coderClazz);
        }

        private static Method getFactoryMethod(Class<?> coderClazz) {
            Method factoryMethodCandidate;
            int numTypeParameters = coderClazz.getTypeParameters().length;
            Object[] factoryMethodArgTypes = new Class[numTypeParameters];
            Arrays.fill(factoryMethodArgTypes, Coder.class);
            try {
                factoryMethodCandidate = coderClazz.getDeclaredMethod("of", (Class<?>[])factoryMethodArgTypes);
            }
            catch (NoSuchMethodException | SecurityException exn) {
                throw new IllegalArgumentException("cannot register Coder " + coderClazz + ": does not have an accessible method named 'of' with " + numTypeParameters + " arguments of Coder type", exn);
            }
            if (!Modifier.isStatic(factoryMethodCandidate.getModifiers())) {
                throw new IllegalArgumentException("cannot register Coder " + coderClazz + ": method named 'of' with " + numTypeParameters + " arguments of Coder type is not static");
            }
            if (!coderClazz.isAssignableFrom(factoryMethodCandidate.getReturnType())) {
                throw new IllegalArgumentException("cannot register Coder " + coderClazz + ": method named 'of' with " + numTypeParameters + " arguments of Coder type does not return a " + coderClazz);
            }
            try {
                if (!factoryMethodCandidate.isAccessible()) {
                    factoryMethodCandidate.setAccessible(true);
                }
            }
            catch (SecurityException exn) {
                throw new IllegalArgumentException("cannot register Coder " + coderClazz + ": method named 'of' with " + numTypeParameters + " arguments of Coder type is not accessible", exn);
            }
            return factoryMethodCandidate;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("rawType", this.rawType).add("factoryMethod", (Object)this.factoryMethod).toString();
        }
    }
}

