/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class BigIntegerCoder
extends AtomicCoder<BigInteger> {
    private static final BigIntegerCoder INSTANCE = new BigIntegerCoder();
    private static final ByteArrayCoder BYTE_ARRAY_CODER = ByteArrayCoder.of();

    public static BigIntegerCoder of() {
        return INSTANCE;
    }

    private BigIntegerCoder() {
    }

    @Override
    public void encode(BigInteger value, OutputStream outStream) throws IOException, CoderException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(BigInteger value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        Preconditions.checkNotNull((Object)value, (Object)String.format("cannot encode a null %s", BigInteger.class.getSimpleName()));
        BYTE_ARRAY_CODER.encode(value.toByteArray(), outStream, context);
    }

    @Override
    public BigInteger decode(InputStream inStream) throws IOException, CoderException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public BigInteger decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        return new BigInteger(BYTE_ARRAY_CODER.decode(inStream, context));
    }

    @Override
    public void verifyDeterministic() {
        BYTE_ARRAY_CODER.verifyDeterministic();
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(BigInteger value) {
        return true;
    }

    @Override
    protected long getEncodedElementByteSize(BigInteger value) throws Exception {
        Preconditions.checkNotNull((Object)value, (Object)String.format("cannot encode a null %s", BigInteger.class.getSimpleName()));
        return BYTE_ARRAY_CODER.getEncodedElementByteSize(value.toByteArray());
    }
}

