/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.translation.types.CoderTypeSerializer;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferedElement;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferedElements;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferingElementsHandler;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.KeyedBufferingElementsHandler;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.NonKeyedBufferingElementsHandler;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

public class BufferingDoFnRunner<InputT, OutputT>
implements DoFnRunner<InputT, OutputT> {
    private final DoFnRunner<InputT, OutputT> underlying;
    private final ListState<CheckpointIdentifier> notYetAcknowledgedSnapshots;
    private final BufferingElementsHandlerFactory bufferingElementsHandlerFactory;
    final int numCheckpointBuffers;
    int currentStateIndex;
    private BufferingElementsHandler currentBufferingElementsHandler;

    public static <InputT, OutputT> BufferingDoFnRunner<InputT, OutputT> create(DoFnRunner<InputT, OutputT> doFnRunner, String stateName, Coder windowedInputCoder, Coder windowCoder, OperatorStateBackend operatorStateBackend, @Nullable KeyedStateBackend<Object> keyedStateBackend, int maxConcurrentCheckpoints, SerializablePipelineOptions pipelineOptions) throws Exception {
        return new BufferingDoFnRunner<InputT, OutputT>(doFnRunner, stateName, windowedInputCoder, windowCoder, operatorStateBackend, keyedStateBackend, maxConcurrentCheckpoints, pipelineOptions);
    }

    private BufferingDoFnRunner(DoFnRunner<InputT, OutputT> underlying, String stateName, Coder inputCoder, Coder windowCoder, OperatorStateBackend operatorStateBackend, @Nullable KeyedStateBackend keyedStateBackend, int maxConcurrentCheckpoints, SerializablePipelineOptions pipelineOptions) throws Exception {
        Preconditions.checkArgument((maxConcurrentCheckpoints > 0 && maxConcurrentCheckpoints < Short.MAX_VALUE ? 1 : 0) != 0, (String)"Maximum number of concurrent checkpoints not within the bounds of 0 and %s", (int)Short.MAX_VALUE);
        this.underlying = underlying;
        this.notYetAcknowledgedSnapshots = operatorStateBackend.getUnionListState(new ListStateDescriptor("notYetAcknowledgedSnapshots", CheckpointIdentifier.class));
        this.bufferingElementsHandlerFactory = stateId -> {
            ListStateDescriptor stateDescriptor = new ListStateDescriptor(stateName + stateId, new CoderTypeSerializer<BufferedElement>(new BufferedElements.Coder((Coder<WindowedValue>)inputCoder, (Coder<BoundedWindow>)windowCoder, null), pipelineOptions));
            if (keyedStateBackend != null) {
                return KeyedBufferingElementsHandler.create(keyedStateBackend, (ListStateDescriptor<BufferedElement>)stateDescriptor);
            }
            return NonKeyedBufferingElementsHandler.create((ListState<BufferedElement>)operatorStateBackend.getListState(stateDescriptor));
        };
        this.numCheckpointBuffers = this.initializeState(maxConcurrentCheckpoints);
        this.currentBufferingElementsHandler = this.bufferingElementsHandlerFactory.get(this.rotateAndGetStateIndex());
    }

    private int initializeState(int maxConcurrentCheckpoints) throws Exception {
        ArrayList pendingSnapshots = new ArrayList();
        Iterables.addAll(pendingSnapshots, (Iterable)((Iterable)this.notYetAcknowledgedSnapshots.get()));
        int lastUsedIndex = -1;
        int maxIndex = 0;
        if (!pendingSnapshots.isEmpty()) {
            for (CheckpointIdentifier checkpointIdentifier : pendingSnapshots) {
                maxIndex = Math.max(maxIndex, checkpointIdentifier.internalId);
            }
            lastUsedIndex = ((CheckpointIdentifier)pendingSnapshots.get((int)(pendingSnapshots.size() - 1))).internalId;
        }
        this.currentStateIndex = lastUsedIndex;
        return Math.max(maxConcurrentCheckpoints, maxIndex) + 1;
    }

    public void startBundle() {
    }

    public void processElement(WindowedValue<InputT> elem) {
        this.currentBufferingElementsHandler.buffer(new BufferedElements.Element(elem));
    }

    public <KeyT> void onTimer(String timerId, String timerFamilyId, KeyT key, BoundedWindow window, Instant timestamp, Instant outputTimestamp, TimeDomain timeDomain) {
        this.currentBufferingElementsHandler.buffer(new BufferedElements.Timer<KeyT>(timerId, timerFamilyId, key, window, timestamp, outputTimestamp, timeDomain));
    }

    public void finishBundle() {
    }

    public <KeyT> void onWindowExpiration(BoundedWindow window, Instant timestamp, KeyT key) {
    }

    public DoFn<InputT, OutputT> getFn() {
        return this.underlying.getFn();
    }

    public void checkpoint(long checkpointId) throws Exception {
        this.addToBeAcknowledgedCheckpoint(checkpointId, this.getStateIndex());
        int newStateIndex = this.rotateAndGetStateIndex();
        this.currentBufferingElementsHandler = this.bufferingElementsHandlerFactory.get(newStateIndex);
    }

    public void checkpointCompleted(long checkpointId) throws Exception {
        List<CheckpointIdentifier> allToAck = this.gatherToBeAcknowledgedCheckpoints(checkpointId);
        for (CheckpointIdentifier toBeAcked : allToAck) {
            BufferingElementsHandler bufferingElementsHandler = this.bufferingElementsHandlerFactory.get(toBeAcked.internalId);
            Iterator iterator = bufferingElementsHandler.getElements().iterator();
            boolean hasElements = iterator.hasNext();
            if (hasElements) {
                this.underlying.startBundle();
            }
            while (iterator.hasNext()) {
                BufferedElement bufferedElement = (BufferedElement)iterator.next();
                bufferedElement.processWith(this.underlying);
            }
            if (hasElements) {
                this.underlying.finishBundle();
            }
            bufferingElementsHandler.clear();
        }
    }

    private void addToBeAcknowledgedCheckpoint(long checkpointId, int internalId) throws Exception {
        this.notYetAcknowledgedSnapshots.addAll(Collections.singletonList(new CheckpointIdentifier(internalId, checkpointId)));
    }

    private List<CheckpointIdentifier> gatherToBeAcknowledgedCheckpoints(long checkpointId) throws Exception {
        ArrayList<CheckpointIdentifier> toBeAcknowledged = new ArrayList<CheckpointIdentifier>();
        ArrayList<CheckpointIdentifier> remaining = new ArrayList<CheckpointIdentifier>();
        for (CheckpointIdentifier element : (Iterable)this.notYetAcknowledgedSnapshots.get()) {
            if (element.checkpointId <= checkpointId) {
                toBeAcknowledged.add(element);
                continue;
            }
            remaining.add(element);
        }
        this.notYetAcknowledgedSnapshots.update(remaining);
        toBeAcknowledged.sort(Comparator.comparingLong(o -> o.checkpointId));
        return toBeAcknowledged;
    }

    private int rotateAndGetStateIndex() {
        this.currentStateIndex = (this.currentStateIndex + 1) % this.numCheckpointBuffers;
        return this.currentStateIndex;
    }

    private int getStateIndex() {
        return this.currentStateIndex;
    }

    static class CheckpointIdentifier {
        final int internalId;
        final long checkpointId;

        CheckpointIdentifier(int internalId, long checkpointId) {
            this.internalId = internalId;
            this.checkpointId = checkpointId;
        }
    }

    private static interface BufferingElementsHandlerFactory {
        public BufferingElementsHandler get(int var1) throws Exception;
    }
}

