/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.ReadWriteTransaction;
import com.google.cloud.spanner.connection.StatementExecutionStep;
import com.google.common.base.Preconditions;
import java.util.Objects;

final class FailedUpdate
implements ReadWriteTransaction.RetriableStatement {
    private final ReadWriteTransaction transaction;
    private final SpannerException exception;
    private final AbstractStatementParser.ParsedStatement statement;

    FailedUpdate(ReadWriteTransaction transaction, SpannerException exception, AbstractStatementParser.ParsedStatement statement) {
        Preconditions.checkNotNull((Object)transaction);
        Preconditions.checkNotNull((Object)((Object)exception));
        Preconditions.checkNotNull((Object)statement);
        this.transaction = transaction;
        this.exception = exception;
        this.statement = statement;
    }

    @Override
    public void retry(AbortedException aborted) throws AbortedException {
        this.transaction.getStatementExecutor().invokeInterceptors(this.statement, StatementExecutionStep.RETRY_STATEMENT, this.transaction);
        try {
            this.transaction.getStatementExecutor().invokeInterceptors(this.statement, StatementExecutionStep.RETRY_STATEMENT, this.transaction);
            this.transaction.getReadContext().executeUpdate(this.statement.getStatement(), new Options.UpdateOption[0]);
        }
        catch (AbortedException e) {
            throw e;
        }
        catch (SpannerException e) {
            if (e.getErrorCode() == this.exception.getErrorCode() && Objects.equals(e.getMessage(), this.exception.getMessage())) {
                return;
            }
            throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException(aborted, e);
        }
        throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException(aborted);
    }
}

