/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.tg;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.tg.TinkerEdge;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import com.tinkerpop.blueprints.impls.tg.TinkerVertex;
import com.tinkerpop.blueprints.util.ElementHelper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

abstract class TinkerElement
implements Element,
Serializable {
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected final String id;
    protected final TinkerGraph graph;

    protected TinkerElement(String id, TinkerGraph graph) {
        this.graph = graph;
        this.id = id;
    }

    @Override
    public Set<String> getPropertyKeys() {
        return new HashSet<String>(this.properties.keySet());
    }

    @Override
    public <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        ElementHelper.validateProperty(this, key, value);
        Object oldValue = this.properties.put(key, value);
        if (this instanceof TinkerVertex) {
            this.graph.vertexKeyIndex.autoUpdate(key, value, oldValue, (TinkerVertex)this);
        } else {
            this.graph.edgeKeyIndex.autoUpdate(key, value, oldValue, (TinkerEdge)this);
        }
    }

    @Override
    public <T> T removeProperty(String key) {
        Object oldValue = this.properties.remove(key);
        if (this instanceof TinkerVertex) {
            this.graph.vertexKeyIndex.autoRemove(key, oldValue, (TinkerVertex)this);
        } else {
            this.graph.edgeKeyIndex.autoRemove(key, oldValue, (TinkerEdge)this);
        }
        return (T)oldValue;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual(this, object);
    }

    @Override
    public void remove() {
        if (this instanceof Vertex) {
            this.graph.removeVertex((Vertex)((Object)this));
        } else {
            this.graph.removeEdge((Edge)((Object)this));
        }
    }
}

