/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.kinesis.CheckpointGenerator;
import org.apache.beam.sdk.io.kinesis.CustomOptional;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.kinesis.KinesisSource;
import org.apache.beam.sdk.io.kinesis.RateLimitPolicyFactory;
import org.apache.beam.sdk.io.kinesis.ShardReadersPool;
import org.apache.beam.sdk.io.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.kinesis.TransientKinesisException;
import org.apache.beam.sdk.io.kinesis.WatermarkPolicyFactory;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KinesisReader
extends UnboundedSource.UnboundedReader<KinesisRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisReader.class);
    private final SimplifiedKinesisClient kinesis;
    private final KinesisSource source;
    private final CheckpointGenerator initialCheckpointGenerator;
    private final WatermarkPolicyFactory watermarkPolicyFactory;
    private final RateLimitPolicyFactory rateLimitPolicyFactory;
    private final Duration upToDateThreshold;
    private final Duration backlogBytesCheckThreshold;
    private CustomOptional<KinesisRecord> currentRecord = CustomOptional.absent();
    private long lastBacklogBytes;
    private Instant backlogBytesLastCheckTime = new Instant(0L);
    private ShardReadersPool shardReadersPool;
    private final Integer maxCapacityPerShard;

    KinesisReader(SimplifiedKinesisClient kinesis, CheckpointGenerator initialCheckpointGenerator, KinesisSource source, WatermarkPolicyFactory watermarkPolicyFactory, RateLimitPolicyFactory rateLimitPolicyFactory, Duration upToDateThreshold, Integer maxCapacityPerShard) {
        this(kinesis, initialCheckpointGenerator, source, watermarkPolicyFactory, rateLimitPolicyFactory, upToDateThreshold, Duration.standardSeconds((long)30L), maxCapacityPerShard);
    }

    KinesisReader(SimplifiedKinesisClient kinesis, CheckpointGenerator initialCheckpointGenerator, KinesisSource source, WatermarkPolicyFactory watermarkPolicyFactory, RateLimitPolicyFactory rateLimitPolicyFactory, Duration upToDateThreshold, Duration backlogBytesCheckThreshold, Integer maxCapacityPerShard) {
        this.kinesis = (SimplifiedKinesisClient)Preconditions.checkNotNull((Object)kinesis, (Object)"kinesis");
        this.initialCheckpointGenerator = (CheckpointGenerator)Preconditions.checkNotNull((Object)initialCheckpointGenerator, (Object)"initialCheckpointGenerator");
        this.watermarkPolicyFactory = watermarkPolicyFactory;
        this.rateLimitPolicyFactory = rateLimitPolicyFactory;
        this.source = source;
        this.upToDateThreshold = upToDateThreshold;
        this.backlogBytesCheckThreshold = backlogBytesCheckThreshold;
        this.maxCapacityPerShard = maxCapacityPerShard;
    }

    public boolean start() throws IOException {
        LOG.info("Starting reader using {}", (Object)this.initialCheckpointGenerator);
        try {
            this.shardReadersPool = this.createShardReadersPool();
            this.shardReadersPool.start();
        }
        catch (TransientKinesisException e) {
            throw new IOException(e);
        }
        return this.advance();
    }

    public boolean advance() throws IOException {
        this.currentRecord = this.shardReadersPool.nextRecord();
        return this.currentRecord.isPresent();
    }

    public byte[] getCurrentRecordId() throws NoSuchElementException {
        return this.currentRecord.get().getUniqueId();
    }

    public KinesisRecord getCurrent() throws NoSuchElementException {
        return this.currentRecord.get();
    }

    public Instant getCurrentTimestamp() throws NoSuchElementException {
        return this.currentRecord.get().getApproximateArrivalTimestamp();
    }

    public void close() throws IOException {
        this.shardReadersPool.stop();
    }

    public Instant getWatermark() {
        return this.shardReadersPool.getWatermark();
    }

    public UnboundedSource.CheckpointMark getCheckpointMark() {
        return this.shardReadersPool.getCheckpointMark();
    }

    public UnboundedSource<KinesisRecord, ?> getCurrentSource() {
        return this.source;
    }

    public long getSplitBacklogBytes() {
        Instant latestRecordTimestamp = this.shardReadersPool.getLatestRecordTimestamp();
        if (latestRecordTimestamp.equals((Object)BoundedWindow.TIMESTAMP_MIN_VALUE)) {
            LOG.debug("Split backlog bytes for stream {} unknown", (Object)this.source.getStreamName());
            return -1L;
        }
        if (latestRecordTimestamp.plus((ReadableDuration)this.upToDateThreshold).isAfterNow()) {
            LOG.debug("Split backlog bytes for stream {} with latest record timestamp {}: 0 (latest record timestamp is up-to-date with threshold of {})", new Object[]{this.source.getStreamName(), latestRecordTimestamp, this.upToDateThreshold});
            return 0L;
        }
        if (this.backlogBytesLastCheckTime.plus((ReadableDuration)this.backlogBytesCheckThreshold).isAfterNow()) {
            LOG.debug("Split backlog bytes for {} stream with latest record timestamp {}: {} (cached value)", new Object[]{this.source.getStreamName(), latestRecordTimestamp, this.lastBacklogBytes});
            return this.lastBacklogBytes;
        }
        try {
            this.lastBacklogBytes = this.kinesis.getBacklogBytes(this.source.getStreamName(), latestRecordTimestamp);
            this.backlogBytesLastCheckTime = Instant.now();
        }
        catch (TransientKinesisException e) {
            LOG.warn("Transient exception occurred during backlog estimation for stream {}.", (Object)this.source.getStreamName(), (Object)e);
        }
        LOG.info("Split backlog bytes for {} stream with {} latest record timestamp: {}", new Object[]{this.source.getStreamName(), latestRecordTimestamp, this.lastBacklogBytes});
        return this.lastBacklogBytes;
    }

    ShardReadersPool createShardReadersPool() throws TransientKinesisException {
        return new ShardReadersPool(this.kinesis, this.initialCheckpointGenerator.generate(this.kinesis), this.watermarkPolicyFactory, this.rateLimitPolicyFactory, this.maxCapacityPerShard);
    }
}

