/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.server;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.sdk.fn.server.FnService;
import org.apache.beam.sdk.fn.server.ServerFactory;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.BindableService;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.Server;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;

public class GrpcFnServer<ServiceT extends FnService>
implements AutoCloseable {
    private final Server server;
    private final ServiceT service;
    private final Endpoints.ApiServiceDescriptor apiServiceDescriptor;

    public static <ServiceT extends FnService> GrpcFnServer<ServiceT> allocatePortAndCreateFor(ServiceT service, ServerFactory factory) throws IOException {
        Endpoints.ApiServiceDescriptor.Builder apiServiceDescriptor = Endpoints.ApiServiceDescriptor.newBuilder();
        Server server = factory.allocateAddressAndCreate((List<BindableService>)ImmutableList.of(service), apiServiceDescriptor);
        return new GrpcFnServer<ServiceT>(server, service, apiServiceDescriptor.build());
    }

    public static List<GrpcFnServer<? extends FnService>> allocatePortAndCreateFor(List<? extends FnService> services, ServerFactory factory) throws IOException {
        Endpoints.ApiServiceDescriptor.Builder apiServiceDescriptor = Endpoints.ApiServiceDescriptor.newBuilder();
        Server server = factory.allocateAddressAndCreate(Collections.unmodifiableList(services), apiServiceDescriptor);
        AtomicInteger countdown = new AtomicInteger(services.size());
        return Lists.transform(services, service -> new SharedGrpcFnServer(server, (FnService)service, apiServiceDescriptor.build(), countdown, null));
    }

    public static List<GrpcFnServer<? extends FnService>> create(List<? extends FnService> services, Endpoints.ApiServiceDescriptor endpoint, ServerFactory factory) throws IOException {
        Server server = factory.create(Collections.unmodifiableList(services), endpoint);
        AtomicInteger countdown = new AtomicInteger(services.size());
        return Lists.transform(services, service -> new SharedGrpcFnServer(server, (FnService)service, endpoint, countdown, null));
    }

    public static <ServiceT extends FnService> GrpcFnServer<ServiceT> create(ServiceT service, Endpoints.ApiServiceDescriptor endpoint, ServerFactory factory) throws IOException {
        return new GrpcFnServer<ServiceT>(factory.create((List<BindableService>)ImmutableList.of(service), endpoint), service, endpoint);
    }

    @Deprecated
    public static <ServiceT extends FnService> GrpcFnServer<ServiceT> create(ServiceT service, Endpoints.ApiServiceDescriptor endpoint) {
        return new GrpcFnServer(null, service, endpoint){

            @Override
            public void close() throws Exception {
            }
        };
    }

    private GrpcFnServer(Server server, ServiceT service, Endpoints.ApiServiceDescriptor apiServiceDescriptor) {
        this.server = server;
        this.service = service;
        this.apiServiceDescriptor = apiServiceDescriptor;
    }

    public Endpoints.ApiServiceDescriptor getApiServiceDescriptor() {
        return this.apiServiceDescriptor;
    }

    public ServiceT getService() {
        return this.service;
    }

    public Server getServer() {
        return this.server;
    }

    @Override
    public void close() throws Exception {
        try {
            this.server.shutdown();
            this.service.close();
            this.server.awaitTermination(60L, TimeUnit.SECONDS);
        }
        finally {
            this.server.shutdownNow();
            this.server.awaitTermination();
        }
    }

    /* synthetic */ GrpcFnServer(Server x0, FnService x1, Endpoints.ApiServiceDescriptor x2, 1 x3) {
        this(x0, x1, x2);
    }

    private static class SharedGrpcFnServer<ServiceT extends FnService>
    extends GrpcFnServer<ServiceT> {
        private AtomicInteger countdown;

        private SharedGrpcFnServer(Server server, ServiceT service, Endpoints.ApiServiceDescriptor apiServiceDescriptor, AtomicInteger countdown) {
            super(server, (FnService)service, apiServiceDescriptor, null);
            this.countdown = countdown;
        }

        @Override
        public void close() throws Exception {
            if (this.countdown.addAndGet(-1) == 0) {
                super.close();
            } else {
                this.getService().close();
            }
        }

        /* synthetic */ SharedGrpcFnServer(Server x0, FnService x1, Endpoints.ApiServiceDescriptor x2, AtomicInteger x3, 1 x4) {
            this(x0, x1, x2, x3);
        }
    }
}

