/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;

public final class ContextItemExpression
extends ComputedExpression {
    ItemType itemType = Type.ITEM_TYPE;

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (itemType == null) {
            StaticError staticError = new StaticError("The context item is undefined at this point");
            staticError.setErrorCode("XPDY0002");
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        this.itemType = itemType;
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        return this.typeCheck(staticContext, itemType);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.itemType;
    }

    public int computeCardinality() {
        return 16384;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public boolean equals(Object object) {
        return object instanceof ContextItemExpression;
    }

    public int hashCode() {
        return "ContextItemExpression".hashCode();
    }

    public int getIntrinsicDependencies() {
        return 2;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            this.dynamicError("The context item is not set", xPathContext);
        }
        return SingletonIterator.makeIterator(item);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            this.dynamicError("The context item is not set", "FONC0001", xPathContext);
        }
        return item;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + '.');
    }
}

