/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricFiltering;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DefaultMetricResults
extends MetricResults {
    private final Iterable<MetricResult<Long>> counters;
    private final Iterable<MetricResult<DistributionResult>> distributions;
    private final Iterable<MetricResult<GaugeResult>> gauges;

    public DefaultMetricResults(Iterable<MetricResult<Long>> counters, Iterable<MetricResult<DistributionResult>> distributions, Iterable<MetricResult<GaugeResult>> gauges) {
        this.counters = counters;
        this.distributions = distributions;
        this.gauges = gauges;
    }

    public MetricQueryResults queryMetrics(@Nullable MetricsFilter filter) {
        return MetricQueryResults.create((Iterable)Iterables.filter(this.counters, counter -> MetricFiltering.matches((MetricsFilter)filter, (MetricKey)counter.getKey())), (Iterable)Iterables.filter(this.distributions, distribution -> MetricFiltering.matches((MetricsFilter)filter, (MetricKey)distribution.getKey())), (Iterable)Iterables.filter(this.gauges, gauge -> MetricFiltering.matches((MetricsFilter)filter, (MetricKey)gauge.getKey())));
    }
}

