/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.CoderTranslation;
import org.apache.beam.runners.core.construction.PCollectionTranslation;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.LoadingCache;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RehydratedComponents {
    private final RunnerApi.Components components;
    private final @Nullable Pipeline pipeline;
    private final LoadingCache<String, WindowingStrategy<?, ?>> windowingStrategies = CacheBuilder.newBuilder().build(new CacheLoader<String, WindowingStrategy<?, ?>>(){

        public WindowingStrategy<?, ?> load(String id) throws Exception {
            // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable RunnerApi.WindowingStrategy windowingStrategyProto = RehydratedComponents.this.components.getWindowingStrategiesOrDefault(id, null);
            Preconditions.checkState((windowingStrategyProto != null ? 1 : 0) != 0, (String)"No WindowingStrategy with id '%s' in serialized components", (Object)id);
            return WindowingStrategyTranslation.fromProto(windowingStrategyProto, RehydratedComponents.this);
        }
    });
    private final LoadingCache<String, Coder<?>> coders = CacheBuilder.newBuilder().build(new CacheLoader<String, Coder<?>>(){

        public Coder<?> load(String id) throws Exception {
            // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable RunnerApi.Coder coder = RehydratedComponents.this.components.getCodersOrDefault(id, null);
            Preconditions.checkState((coder != null ? 1 : 0) != 0, (String)"No coder with id '%s' in serialized components", (Object)id);
            return CoderTranslation.fromProto(coder, RehydratedComponents.this, CoderTranslation.TranslationContext.DEFAULT);
        }
    });
    private final LoadingCache<String, PCollection<?>> pCollections = CacheBuilder.newBuilder().build(new CacheLoader<String, PCollection<?>>(){

        public PCollection<?> load(String id) throws Exception {
            Preconditions.checkState((RehydratedComponents.this.pipeline != null ? 1 : 0) != 0, (String)"%s Cannot rehydrate %s without a %s: provide one via .withPipeline(...)", (Object)RehydratedComponents.class.getSimpleName(), (Object)PCollection.class.getSimpleName(), (Object)Pipeline.class.getSimpleName());
            return PCollectionTranslation.fromProto(RehydratedComponents.this.components.getPcollectionsOrThrow(id), RehydratedComponents.this.pipeline, RehydratedComponents.this).setName(id);
        }
    });

    public static RehydratedComponents forComponents(RunnerApi.Components components) {
        return new RehydratedComponents(components, null);
    }

    public RehydratedComponents withPipeline(Pipeline pipeline) {
        return new RehydratedComponents(this.components, pipeline);
    }

    private RehydratedComponents(RunnerApi.Components components, @Nullable Pipeline pipeline) {
        this.components = components;
        this.pipeline = pipeline;
    }

    public PCollection<?> getPCollection(String pCollectionId) throws IOException {
        try {
            return (PCollection)this.pCollections.get((Object)pCollectionId);
        }
        catch (ExecutionException exc) {
            throw new RuntimeException(exc);
        }
    }

    public WindowingStrategy<?, ?> getWindowingStrategy(String windowingStrategyId) throws IOException {
        try {
            return (WindowingStrategy)this.windowingStrategies.get((Object)windowingStrategyId);
        }
        catch (ExecutionException exc) {
            throw new RuntimeException(exc);
        }
    }

    public Coder<?> getCoder(String coderId) throws IOException {
        try {
            return (Coder)this.coders.get((Object)coderId);
        }
        catch (ExecutionException exc) {
            throw new RuntimeException(exc);
        }
    }

    public RunnerApi.Environment getEnvironment(String environmentId) {
        return this.components.getEnvironmentsOrThrow(environmentId);
    }

    public RunnerApi.Components getComponents() {
        return this.components;
    }

    public SdkComponents getSdkComponents(Collection<String> requirements) {
        return SdkComponents.create(this.components, Collections.emptyMap(), this.pCollections.asMap(), this.windowingStrategies.asMap(), this.coders.asMap(), Collections.emptyMap(), requirements);
    }
}

