/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.io.IOException;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.spark.structuredstreaming.io.BoundedDatasetFactory;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.SparkSession;

class ReadSourceTranslatorBatch<T>
extends TransformTranslator<PBegin, PCollection<T>, SplittableParDo.PrimitiveBoundedRead<T>> {
    ReadSourceTranslatorBatch() {
    }

    @Override
    public void translate(SplittableParDo.PrimitiveBoundedRead<T> transform, TransformTranslator.Context cxt) throws IOException {
        SparkSession session = cxt.getSparkSession();
        BoundedSource source = transform.getSource();
        SerializablePipelineOptions options = cxt.getSerializableOptions();
        Encoder encoder = cxt.windowedEncoder(source.getOutputCoder(), GlobalWindow.Coder.INSTANCE);
        cxt.putDataset((PCollection)cxt.getOutput(), BoundedDatasetFactory.createDatasetFromRDD(session, source, options, encoder));
    }
}

