/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.runners.spark.structuredstreaming.SparkStructuredStreamingPipelineOptions;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;

public class SparkSessionFactory {
    public static SparkSession getOrCreateSession(SparkStructuredStreamingPipelineOptions options) {
        if (options.getUseActiveSparkSession()) {
            return SparkSession.active();
        }
        return SparkSessionFactory.sessionBuilder(options.getSparkMaster(), options.getAppName(), options.getFilesToStage()).getOrCreate();
    }

    public static SparkSession.Builder sessionBuilder(String master) {
        return SparkSessionFactory.sessionBuilder(master, null, null);
    }

    private static SparkSession.Builder sessionBuilder(String master, @Nullable String appName, @Nullable List<String> jars) {
        int numPartitions;
        SparkConf sparkConf = new SparkConf();
        sparkConf.setMaster(master);
        if (appName != null) {
            sparkConf.setAppName(appName);
        }
        if (jars != null && !jars.isEmpty()) {
            sparkConf.setJars(jars.toArray(new String[0]));
        }
        if (master != null && !master.equals("local[*]") && master.startsWith("local[") && System.getProperty("spark.sql.shuffle.partitions") == null && (numPartitions = Integer.parseInt(master.substring("local[".length(), master.length() - 1))) > 0) {
            sparkConf.set("spark.sql.shuffle.partitions", String.valueOf(numPartitions));
        }
        return SparkSession.builder().config(sparkConf);
    }
}

