/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.PrintObjectPageInputStream;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;

public class SpooledFileViewer
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int ABSOLUTE_FIDELITY = 0;
    public static final int CONTENT_FIDELITY = 1;
    public static final int LETTER = 0;
    public static final int LEGAL = 1;
    public static final int A3 = 2;
    public static final int A4 = 3;
    public static final int A5 = 4;
    public static final int B4 = 5;
    public static final int B5 = 6;
    public static final int EXECUTIVE = 7;
    public static final int LEDGER = 8;
    public static final int CONT80 = 9;
    public static final int CONT132 = 10;
    public static final int NONE = 11;
    private static final int BSIZE_ = 36;
    private static final int LISTBOXWIDTH_ = 300;
    private static final int LISTBOXHEIGHT_ = 175;
    private static final int PREF_WIDTH = 465;
    private static final int PREF_HEIGHT = 600;
    private static final int TOOLBARSIZE_ = 38;
    private static final int TOPOFFSET_ = 1;
    private static final String WSCSTOBJ = "/QSYS.LIB/QWPGIF.WSCST";
    private static final String a3Text_ = ResourceLoader.getPrintText("PAPER_SIZE_A3");
    private static final String a4Text_ = ResourceLoader.getPrintText("PAPER_SIZE_A4");
    private static final String a5Text_ = ResourceLoader.getPrintText("PAPER_SIZE_A5");
    private static final String absoluteText_ = ResourceLoader.getPrintText("FIDELITY_ABSOLUTE");
    private static final String actualSizeText_ = ResourceLoader.getText("MENU_ACTUAL_SIZE");
    private static final String b4Text_ = ResourceLoader.getPrintText("PAPER_SIZE_B4");
    private static final String b5Text_ = ResourceLoader.getPrintText("PAPER_SIZE_B5");
    private static final String cancelText_ = ResourceLoader.getText("DLG_CANCEL");
    private static final String cont80Text_ = ResourceLoader.getPrintText("PAPER_SIZE_CONT80");
    private static final String cont132Text_ = ResourceLoader.getPrintText("PAPER_SIZE_CONT132");
    private static final String contentText_ = ResourceLoader.getPrintText("FIDELITY_CONTENT");
    private static final String curPaperText_ = ResourceLoader.getPrintText("CURRENT_PAPER_SIZE");
    private static final String curVFidelityText_ = ResourceLoader.getPrintText("CURRENT_VIEWING_FIDELITY");
    private static final String executiveText_ = ResourceLoader.getPrintText("PAPER_SIZE_EXECUTIVE");
    private static final String firstPageText_ = ResourceLoader.getText("MENU_FIRST_PAGE");
    private static final String fitPageText_ = ResourceLoader.getText("MENU_FIT_PAGE");
    private static final String fitWidthText_ = ResourceLoader.getText("MENU_FIT_WIDTH");
    private static final String flashPageText_ = ResourceLoader.getText("MENU_FLASH_PAGE");
    private static final String goToText_ = ResourceLoader.getText("MENU_GO_TO_PAGE");
    private static final String goToPageText_ = ResourceLoader.getPrintText("GO_TO_PAGE");
    private static final String lastPageText_ = ResourceLoader.getText("MENU_LAST_PAGE");
    private static final String ledgerText_ = ResourceLoader.getPrintText("PAPER_SIZE_LEDGER");
    private static final String legalText_ = ResourceLoader.getPrintText("PAPER_SIZE_LEGAL");
    private static final String letterText_ = ResourceLoader.getPrintText("PAPER_SIZE_LETTER");
    private static final String nextPageText_ = ResourceLoader.getText("MENU_NEXT_PAGE");
    private static final String noneText_ = ResourceLoader.getPrintText("NONE");
    private static final String okText_ = ResourceLoader.getText("DLG_OK");
    private static final String paperSizeText_ = ResourceLoader.getPrintText("PAPER_SIZE");
    private static final String paperSizeWarnText_ = ResourceLoader.getPrintText("WARNING_PAPER_SIZE");
    private static final String prevPageText_ = ResourceLoader.getText("MENU_PREVIOUS_PAGE");
    private static final String vFidelityText_ = ResourceLoader.getPrintText("VIEWING_FIDELITY");
    private static final String vFidelityWarnText_ = ResourceLoader.getPrintText("WARNING_FIDELITY");
    private static final String warningText_ = ResourceLoader.getPrintText("WARNING");
    private static final String zoomText_ = ResourceLoader.getText("MENU_ZOOM");
    private static final Icon iconActualSize_ = ResourceLoader.getIcon("ResetViewIcon.gif");
    private static final Icon iconFirstPage_ = ResourceLoader.getIcon("FirstIcon.gif");
    private static final Icon iconFitPage_ = ResourceLoader.getIcon("FitPageIcon.gif");
    private static final Icon iconFitWidth_ = ResourceLoader.getIcon("FitWidthIcon.gif");
    private static final Icon iconFlashPage_ = ResourceLoader.getIcon("FlashIcon.gif");
    private static final Icon iconGoToPage_ = ResourceLoader.getIcon("GoToIcon.gif");
    private static final Icon iconLastPage_ = ResourceLoader.getIcon("LastIcon.gif");
    private static final Icon iconNextPage_ = ResourceLoader.getIcon("NextIcon.gif");
    private static final Icon iconPaperSize_ = ResourceLoader.getIcon("PaperIcon.gif");
    private static final Icon iconPrevPage_ = ResourceLoader.getIcon("PreviousIcon.gif");
    private static final Icon iconViewFidelity_ = ResourceLoader.getIcon("VFIcon.gif");
    private static final Icon iconZoom_ = ResourceLoader.getIcon("ZoomIcon.gif");
    private static final String[] paperSizes = new String[]{letterText_, legalText_, a3Text_, a4Text_, a5Text_, b4Text_, b5Text_, executiveText_, ledgerText_, cont80Text_, cont132Text_, noneText_};
    private static final String[] paperSizeValues = new String[]{"*LETTER", "*LEGAL", "*A3", "*A4", "*A5", "*B4", "*B5", "*EXECUTIVE", "*LEDGER", "*CONT80", "*CONT132", "*NONE"};
    private static final String[] viewingFidelities = new String[]{absoluteText_, contentText_};
    private static final String[] viewingValues = new String[]{"*ABSOLUTE", "*CONTENT"};
    private static int sPaperSize_ = 0;
    private static int sViewingFidelity_ = 1;
    private static boolean paperSizeChecked_ = false;
    private transient Image currentPageImage_ = null;
    private transient Image flashPageImage_ = null;
    private transient PrintObjectPageInputStream spooledFileIS_ = null;
    private boolean initialized_ = false;
    private boolean numberOfPagesEst_ = false;
    private int currentPageNumber_ = 0;
    private int flashPageNumber_ = 0;
    private int knownPages_ = 0;
    private int numberOfPages_ = 0;
    private int oldCurrentPage_ = 0;
    private int paperSize_ = 0;
    private int viewingFidelity_ = 0;
    private float zoomPercentage_ = 100.0f;
    private transient JButton actualButton_ = null;
    private transient JButton firstPageButton_ = null;
    private transient JButton fitPageButton_ = null;
    private transient JButton fitWidthButton_ = null;
    private transient JButton flashButton_ = null;
    private transient JButton gotoButton_ = null;
    private transient JButton lastPageButton_ = null;
    private transient JButton nextPageButton_ = null;
    private transient JButton paperSizeButton_ = null;
    private transient JButton prevPageButton_ = null;
    private transient JButton viewingFidelityButton_ = null;
    private transient JButton zoomButton_ = null;
    private transient JPanel statusBar_ = null;
    private transient JPanel toolBar_ = null;
    private transient JScrollPane scrollView_ = null;
    private SpooledFile spooledFile_ = null;
    private SpooledFilePageView_ pageView_ = null;
    private String estimateStar_ = "";
    private transient JTextField pageInfo_ = null;
    private transient JTextField zoomInfo_ = null;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public SpooledFileViewer() {
        this.spooledFile_ = null;
        this.createViewer();
    }

    public SpooledFileViewer(SpooledFile spooledFile) {
        if (spooledFile == null) {
            throw new NullPointerException("spooledFile");
        }
        this.spooledFile_ = spooledFile;
        this.createViewer();
        this.currentPageNumber_ = 1;
    }

    public SpooledFileViewer(SpooledFile spooledFile, int n) {
        if (spooledFile == null) {
            throw new NullPointerException("spooledFile");
        }
        if (n < 1) {
            throw new IllegalArgumentException("page");
        }
        this.spooledFile_ = spooledFile;
        this.createViewer();
        this.currentPageNumber_ = n;
    }

    public void actualSize() {
        if (this.initialized_) {
            this.pageView_.clearView();
            Dimension dimension = new Dimension(this.currentPageImage_.getWidth(this), this.currentPageImage_.getHeight(this));
            this.pageView_.setViewSize(dimension);
            this.calculateZoom();
            this.updateViewer();
        }
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addStatusBar() {
        this.add("South", this.statusBar_);
        this.validate();
    }

    public void addToolBar() {
        this.add("North", this.toolBar_);
        this.validate();
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.addVetoableChangeListener(vetoableChangeListener);
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    private void calculateZoom() {
        float f = this.getPageImageSize().width;
        if (f != 0.0f) {
            this.zoomPercentage_ = (float)this.pageView_.getWidth() / f * 100.0f;
        } else {
            this.errorEventSupport_.fireError(new ArithmeticException());
        }
    }

    void changeCurrentPage() {
        GoToBox_ goToBox_ = new GoToBox_((JFrame)VUtilities.getFrame(this));
        goToBox_.setVisible(true);
    }

    void changePaperSize() {
        PaperSizeBox_ paperSizeBox_ = new PaperSizeBox_((JFrame)VUtilities.getFrame(this));
        paperSizeBox_.setVisible(true);
    }

    void changeViewingFidelity() {
        ViewingFidelityBox_ viewingFidelityBox_ = new ViewingFidelityBox_((JFrame)VUtilities.getFrame(this));
        viewingFidelityBox_.setVisible(true);
    }

    void changeZoom() {
        ZoomToBox_ zoomToBox_ = new ZoomToBox_((JFrame)VUtilities.getFrame(this));
        zoomToBox_.setVisible(true);
    }

    public void close() {
        try {
            if (this.spooledFileIS_ != null) {
                this.spooledFileIS_.close();
                this.spooledFileIS_ = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private JPanel createStatusBar() {
        JPanel jPanel = new JPanel();
        this.pageInfo_ = new JTextField(22);
        this.pageInfo_.setEditable(false);
        this.pageInfo_.transferFocus();
        this.zoomInfo_ = new JTextField(8);
        this.zoomInfo_.setEditable(false);
        this.zoomInfo_.transferFocus();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(this.pageInfo_);
        jPanel.add(this.zoomInfo_);
        return jPanel;
    }

    private JPanel createToolBar() {
        JPanel jPanel = new JPanel();
        Insets insets = jPanel.getInsets();
        ViewerActionListener_ viewerActionListener_ = new ViewerActionListener_();
        jPanel.setPreferredSize(new Dimension(38, 38));
        jPanel.setLayout(null);
        this.actualButton_ = new JButton(iconActualSize_);
        jPanel.add(this.actualButton_);
        this.actualButton_.setBounds(insets.left + 1, insets.top + 1, 36, 36);
        this.actualButton_.addActionListener(viewerActionListener_);
        this.actualButton_.setToolTipText(actualSizeText_);
        this.actualButton_.setActionCommand("actualSize");
        this.fitWidthButton_ = new JButton(iconFitWidth_);
        jPanel.add(this.fitWidthButton_);
        this.fitWidthButton_.setBounds(insets.left + 37, insets.top + 1, 36, 36);
        this.fitWidthButton_.addActionListener(viewerActionListener_);
        this.fitWidthButton_.setToolTipText(fitWidthText_);
        this.fitWidthButton_.setActionCommand("fitWidth");
        this.fitPageButton_ = new JButton(iconFitPage_);
        jPanel.add(this.fitPageButton_);
        this.fitPageButton_.setBounds(insets.left + 73, insets.top + 1, 36, 36);
        this.fitPageButton_.addActionListener(viewerActionListener_);
        this.fitPageButton_.setToolTipText(fitPageText_);
        this.fitPageButton_.setActionCommand("fitPage");
        this.zoomButton_ = new JButton(iconZoom_);
        jPanel.add(this.zoomButton_);
        this.zoomButton_.setBounds(insets.left + 109, insets.top + 1, 36, 36);
        this.zoomButton_.addActionListener(viewerActionListener_);
        this.zoomButton_.setToolTipText(zoomText_);
        this.zoomButton_.setActionCommand("zoom");
        this.gotoButton_ = new JButton(iconGoToPage_);
        jPanel.add(this.gotoButton_);
        this.gotoButton_.setBounds(insets.left + 152, insets.top + 1, 36, 36);
        this.gotoButton_.addActionListener(viewerActionListener_);
        this.gotoButton_.setToolTipText(goToText_);
        this.gotoButton_.setActionCommand("goToPage");
        this.firstPageButton_ = new JButton(iconFirstPage_);
        jPanel.add(this.firstPageButton_);
        this.firstPageButton_.setBounds(insets.left + 195, insets.top + 1, 36, 36);
        this.firstPageButton_.addActionListener(viewerActionListener_);
        this.firstPageButton_.setToolTipText(firstPageText_);
        this.firstPageButton_.setActionCommand("firstPage");
        this.prevPageButton_ = new JButton(iconPrevPage_);
        jPanel.add(this.prevPageButton_);
        this.prevPageButton_.setBounds(insets.left + 231, insets.top + 1, 36, 36);
        this.prevPageButton_.addActionListener(viewerActionListener_);
        this.prevPageButton_.setToolTipText(prevPageText_);
        this.prevPageButton_.setActionCommand("prevPage");
        this.nextPageButton_ = new JButton(iconNextPage_);
        jPanel.add(this.nextPageButton_);
        this.nextPageButton_.setBounds(insets.left + 267, insets.top + 1, 36, 36);
        this.nextPageButton_.addActionListener(viewerActionListener_);
        this.nextPageButton_.setToolTipText(nextPageText_);
        this.nextPageButton_.setActionCommand("nextPage");
        this.lastPageButton_ = new JButton(iconLastPage_);
        jPanel.add(this.lastPageButton_);
        this.lastPageButton_.setBounds(insets.left + 303, insets.top + 1, 36, 36);
        this.lastPageButton_.addActionListener(viewerActionListener_);
        this.lastPageButton_.setToolTipText(lastPageText_);
        this.lastPageButton_.setActionCommand("lastPage");
        this.flashButton_ = new JButton(iconFlashPage_);
        jPanel.add(this.flashButton_);
        this.flashButton_.setBounds(insets.left + 346, insets.top + 1, 36, 36);
        this.flashButton_.addActionListener(viewerActionListener_);
        this.flashButton_.setToolTipText(flashPageText_);
        this.flashButton_.setActionCommand("flashPage");
        this.paperSizeButton_ = new JButton(iconPaperSize_);
        jPanel.add(this.paperSizeButton_);
        this.paperSizeButton_.setBounds(insets.left + 389, insets.top + 1, 36, 36);
        this.paperSizeButton_.addActionListener(viewerActionListener_);
        this.paperSizeButton_.setToolTipText(paperSizeText_);
        this.paperSizeButton_.setActionCommand("changePaperSize");
        this.viewingFidelityButton_ = new JButton(iconViewFidelity_);
        jPanel.add(this.viewingFidelityButton_);
        this.viewingFidelityButton_.setBounds(insets.left + 425, insets.top + 1, 36, 36);
        this.viewingFidelityButton_.addActionListener(viewerActionListener_);
        this.viewingFidelityButton_.setToolTipText(vFidelityText_);
        this.viewingFidelityButton_.setActionCommand("changeViewingFidelity");
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createViewer() {
        this.initializeTransient();
        if (!paperSizeChecked_) {
            try {
                Locale locale = Locale.getDefault();
                String string = locale.getISO3Country();
                if (string.equals("USA") || string.equals("CAN") || string.equals("BRA") || string.equals("MEX")) {
                    this.paperSize_ = 0;
                }
                this.paperSize_ = 3;
            }
            catch (MissingResourceException missingResourceException) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Default paper size selected");
                }
                this.paperSize_ = 3;
            }
            finally {
                paperSizeChecked_ = true;
            }
        } else {
            this.paperSize_ = sPaperSize_;
        }
        this.viewingFidelity_ = sViewingFidelity_;
        this.setLayout(new BorderLayout());
        this.toolBar_ = this.createToolBar();
        this.addToolBar();
        this.scrollView_ = new JScrollPane(22, 32);
        this.add("Center", this.scrollView_);
        this.statusBar_ = this.createStatusBar();
        this.addStatusBar();
        this.disableViewerButtons();
        this.repaint();
    }

    private void disableViewerButtons() {
        this.actualButton_.setEnabled(false);
        this.firstPageButton_.setEnabled(false);
        this.fitPageButton_.setEnabled(false);
        this.fitWidthButton_.setEnabled(false);
        this.flashButton_.setEnabled(false);
        this.gotoButton_.setEnabled(false);
        this.lastPageButton_.setEnabled(false);
        this.nextPageButton_.setEnabled(false);
        this.paperSizeButton_.setEnabled(false);
        this.prevPageButton_.setEnabled(false);
        this.viewingFidelityButton_.setEnabled(false);
        this.zoomButton_.setEnabled(false);
    }

    void displayPropertyChangeWarning(String string, int n) {
        boolean bl = false;
        Object[] objectArray = new Object[]{okText_, cancelText_};
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.ms.security.PolicyEngine");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (clazz != null) {
            bl = true;
        }
        if (string.equals("viewingFidelity")) {
            if (!bl) {
                int n2 = JOptionPane.showOptionDialog(this, vFidelityWarnText_, warningText_, -1, 2, null, objectArray, objectArray[0]);
                if (n2 == 0) {
                    try {
                        this.setViewingFidelity(n);
                        this.load();
                    }
                    catch (Exception exception) {}
                }
            } else {
                WarningDialogBox_ warningDialogBox_ = new WarningDialogBox_((JFrame)VUtilities.getFrame(this), vFidelityWarnText_, string, n);
                warningDialogBox_.setVisible(true);
            }
        } else if (string.equals("paperSize")) {
            if (!bl) {
                int n3 = JOptionPane.showOptionDialog(this, paperSizeWarnText_, warningText_, -1, 2, null, objectArray, objectArray[0]);
                if (n3 == 0) {
                    try {
                        this.setPaperSize(n);
                        this.load();
                    }
                    catch (Exception exception) {}
                }
            } else {
                WarningDialogBox_ warningDialogBox_ = new WarningDialogBox_((JFrame)VUtilities.getFrame(this), paperSizeWarnText_, string, n);
                warningDialogBox_.setVisible(true);
            }
        } else if (Trace.isTraceOn()) {
            Trace.log(2, "Property for 'displayPropertyChangeWarning' not valid");
        }
    }

    private void enableViewerButtons() {
        this.actualButton_.setEnabled(true);
        this.firstPageButton_.setEnabled(true);
        this.fitPageButton_.setEnabled(true);
        this.fitWidthButton_.setEnabled(true);
        this.flashButton_.setEnabled(true);
        this.gotoButton_.setEnabled(true);
        this.lastPageButton_.setEnabled(true);
        this.nextPageButton_.setEnabled(true);
        this.paperSizeButton_.setEnabled(true);
        this.prevPageButton_.setEnabled(true);
        this.viewingFidelityButton_.setEnabled(true);
        this.zoomButton_.setEnabled(true);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.spooledFileIS_ != null) {
                this.spooledFileIS_.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }

    public void fitHeight() {
        if (this.initialized_) {
            this.pageView_.clearView();
            JViewport jViewport = this.scrollView_.getViewport();
            Dimension dimension = jViewport.getExtentSize();
            if (dimension.width < 0) {
                dimension.width = 0;
            }
            if (dimension.height < 0) {
                dimension.height = 0;
            }
            Dimension dimension2 = new Dimension();
            dimension2.height = dimension.height;
            dimension2.width = this.currentPageImage_.getWidth(this) * dimension.height / this.currentPageImage_.getHeight(this);
            this.pageView_.setViewSize(dimension2);
            this.calculateZoom();
            this.updateViewer();
        }
    }

    public void fitPage() {
        if (this.initialized_) {
            Dimension dimension = this.scrollView_.getSize();
            Dimension dimension2 = this.scrollView_.getViewport().getExtentSize();
            if (dimension2.width < 0) {
                dimension2.width = 0;
            }
            if (dimension2.height < 0) {
                dimension2.height = 0;
            }
            int n = this.pageView_.getWidth();
            int n2 = this.pageView_.getHeight();
            if (n <= dimension2.width && n2 >= dimension2.height) {
                this.fitHeight();
            } else if (n >= dimension2.width && n2 <= dimension2.height) {
                this.fitWidth();
            } else if (n < dimension2.width) {
                if (Math.abs(dimension.width - n) < Math.abs(dimension.height - n2)) {
                    this.fitWidth();
                } else {
                    this.fitHeight();
                }
            } else if (Math.abs(dimension.width - n) < Math.abs(dimension.height - n2)) {
                this.fitHeight();
            } else {
                this.fitWidth();
            }
        }
    }

    public void fitWidth() {
        if (this.initialized_) {
            this.pageView_.clearView();
            JViewport jViewport = this.scrollView_.getViewport();
            Dimension dimension = jViewport.getExtentSize();
            if (dimension.width < 0) {
                dimension.width = 0;
            }
            if (dimension.height < 0) {
                dimension.height = 0;
            }
            Dimension dimension2 = new Dimension();
            dimension2.width = dimension.width;
            dimension2.height = this.currentPageImage_.getHeight(this) * dimension.width / this.currentPageImage_.getWidth(this);
            this.pageView_.setViewSize(dimension2);
            this.calculateZoom();
            this.updateViewer();
        }
    }

    public int getCurrentPage() {
        return this.currentPageNumber_;
    }

    public int getNumberOfPages() {
        return this.numberOfPages_;
    }

    private synchronized Image getPageImage(int n) throws IOException {
        Image image = null;
        if (this.spooledFileIS_ == null) {
            throw new IOException();
        }
        try {
            boolean bl = this.spooledFileIS_.selectPage(n);
            if (!bl) {
                throw new IOException();
            }
            int n2 = this.spooledFileIS_.available();
            if (n2 == 0) {
                throw new IOException();
            }
            byte[] byArray = new byte[n2];
            this.spooledFileIS_.read(byArray, 0, n2);
            Frame frame = new Frame();
            Toolkit toolkit = frame.getToolkit();
            MediaTracker mediaTracker = new MediaTracker(frame);
            image = toolkit.createImage(byArray);
            if (image != null) {
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForID(0);
                mediaTracker = null;
            }
        }
        catch (Exception exception) {
            throw new IOException();
        }
        return image;
    }

    private Dimension getPageImageSize() {
        if (this.currentPageImage_ != null) {
            return new Dimension(this.currentPageImage_.getWidth(this), this.currentPageImage_.getHeight(this));
        }
        return new Dimension(0, 0);
    }

    public int getPaperSize() {
        return this.paperSize_;
    }

    public Dimension getPreferredSize() {
        if (this.pageView_ != null && this.pageView_.getWidth() < 500 && this.pageView_.getHeight() < 700) {
            return new Dimension(this.pageView_.getWidth() + 25, this.pageView_.getHeight() + 38 + this.statusBar_.getPreferredSize().height);
        }
        return new Dimension(465, 600);
    }

    public SpooledFile getSpooledFile() {
        return this.spooledFile_;
    }

    public int getViewingFidelity() {
        return this.viewingFidelity_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.addWorkingListener(new WorkingCursorAdapter(this));
        this.addFocusListener(new SerializationListener(this));
    }

    public boolean isNumberOfPagesEstimated() {
        return this.numberOfPagesEst_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException, PropertyVetoException {
        if (this.spooledFile_ == null) {
            this.errorEventSupport_.fireError(new IllegalStateException("spooledFile"));
        } else {
            this.workingEventSupport_.fireStartWorking();
            try {
                this.initialized_ = false;
                this.disableViewerButtons();
                PrintParameterList printParameterList = new PrintParameterList();
                printParameterList.setParameter(-8, WSCSTOBJ);
                printParameterList.setParameter(65, "*WSCST");
                printParameterList.setParameter(216, viewingValues[this.viewingFidelity_]);
                printParameterList.setParameter(212, paperSizeValues[this.paperSize_]);
                if (this.spooledFileIS_ != null) {
                    this.spooledFileIS_.close();
                }
                this.spooledFileIS_ = this.spooledFile_.getPageInputStream(printParameterList);
                if (this.spooledFileIS_ == null) {
                    throw new IOException();
                }
                int n = this.spooledFileIS_.getNumberOfPages();
                this.vetoableChangeSupport_.fireVetoableChange("numberOfPages", new Integer(this.numberOfPages_), new Integer(n));
                int n2 = this.numberOfPages_;
                this.numberOfPages_ = n;
                this.propertyChangeSupport_.firePropertyChange("numberOfPages", new Integer(n2), new Integer(this.numberOfPages_));
                boolean bl = this.spooledFileIS_.isPagesEstimated();
                this.vetoableChangeSupport_.fireVetoableChange("numberOfPagesEstimated", new Boolean(this.numberOfPagesEst_), new Boolean(bl));
                boolean bl2 = this.numberOfPagesEst_;
                this.numberOfPagesEst_ = bl;
                this.propertyChangeSupport_.firePropertyChange("numberOfPagesEstimated", new Boolean(bl2), new Boolean(this.numberOfPagesEst_));
                if (this.numberOfPagesEst_) {
                    this.estimateStar_ = "*";
                }
                try {
                    this.currentPageImage_ = this.getPageImage(this.currentPageNumber_);
                    this.oldCurrentPage_ = this.currentPageNumber_;
                    this.knownPages_ = this.currentPageNumber_;
                }
                catch (IOException iOException) {
                    if (this.currentPageNumber_ != 1) {
                        this.setCurrentPage(1);
                        this.currentPageImage_ = this.getPageImage(this.currentPageNumber_);
                        this.oldCurrentPage_ = this.currentPageNumber_;
                        this.knownPages_ = this.currentPageNumber_;
                    }
                    if (Trace.isTraceOn()) {
                        Trace.log(2, "Error initializing spooled file viewer");
                    }
                    throw iOException;
                }
                this.pageView_ = new SpooledFilePageView_();
                this.scrollView_.setViewportView(this.pageView_);
                this.enableViewerButtons();
                this.initialized_ = true;
                this.calculateZoom();
                this.updateViewer();
                this.validate();
            }
            catch (Exception exception) {
                this.initialized_ = false;
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Error initializing spooled file viewer");
                }
                this.errorEventSupport_.fireError(exception);
            }
            finally {
                this.workingEventSupport_.fireStopWorking();
            }
        }
    }

    public void loadFlashPage() throws PropertyVetoException {
        if (this.initialized_) {
            if (this.flashPageImage_ != null) {
                this.vetoableChangeSupport_.fireVetoableChange("currentPage", new Integer(this.oldCurrentPage_), new Integer(this.flashPageNumber_));
                this.pageView_.clearView();
                int n = this.flashPageNumber_;
                this.flashPageNumber_ = this.oldCurrentPage_;
                this.currentPageNumber_ = n;
                Image image = this.flashPageImage_;
                this.flashPageImage_ = this.currentPageImage_;
                this.currentPageImage_ = image;
                this.oldCurrentPage_ = this.currentPageNumber_;
                Dimension dimension = this.getPageImageSize();
                Dimension dimension2 = new Dimension();
                dimension2.width = (int)((float)dimension.width * (this.zoomPercentage_ / 100.0f));
                dimension2.height = (int)((float)dimension.height * (this.zoomPercentage_ / 100.0f));
                this.pageView_.setViewSize(dimension2);
                this.updateViewer();
                this.propertyChangeSupport_.firePropertyChange("currentPage", new Integer(this.flashPageNumber_), new Integer(this.currentPageNumber_));
            }
        } else {
            this.errorEventSupport_.fireError(new IllegalStateException());
        }
    }

    public void loadPage() throws PropertyVetoException {
        this.workingEventSupport_.fireStartWorking();
        if (this.initialized_) {
            if (this.currentPageNumber_ != this.oldCurrentPage_) {
                if (this.currentPageNumber_ == this.flashPageNumber_) {
                    this.loadFlashPage();
                } else {
                    try {
                        Image image = this.getPageImage(this.currentPageNumber_);
                        this.flashPageNumber_ = this.oldCurrentPage_;
                        this.flashPageImage_ = this.currentPageImage_;
                        this.oldCurrentPage_ = this.currentPageNumber_;
                        this.currentPageImage_ = image;
                        if (this.numberOfPagesEst_ && this.currentPageNumber_ > this.knownPages_) {
                            this.knownPages_ = this.currentPageNumber_;
                        }
                    }
                    catch (IOException iOException) {
                        int n;
                        if (this.numberOfPagesEst_ && this.currentPageNumber_ == this.knownPages_ + 1) {
                            this.vetoableChangeSupport_.fireVetoableChange("numberOfPages", new Integer(this.numberOfPages_), new Integer(this.knownPages_));
                            n = this.numberOfPages_;
                            this.numberOfPages_ = this.knownPages_;
                            this.propertyChangeSupport_.firePropertyChange("numberOfPages", new Integer(n), new Integer(this.numberOfPages_));
                            this.vetoableChangeSupport_.fireVetoableChange("numberOfPagesEstimated", new Boolean(true), new Boolean(false));
                            this.numberOfPagesEst_ = false;
                            this.estimateStar_ = "";
                            this.propertyChangeSupport_.firePropertyChange("numberOfPagesEstimated", new Boolean(true), new Boolean(false));
                        }
                        this.vetoableChangeSupport_.fireVetoableChange("currentPage", new Integer(this.currentPageNumber_), new Integer(this.oldCurrentPage_));
                        n = this.currentPageNumber_;
                        this.currentPageNumber_ = this.oldCurrentPage_;
                        this.propertyChangeSupport_.firePropertyChange("currentPage", new Integer(n), new Integer(this.currentPageNumber_));
                        this.errorEventSupport_.fireError(new IOException());
                    }
                }
            }
            Dimension dimension = this.getPageImageSize();
            Dimension dimension2 = new Dimension();
            dimension2.width = (int)((float)dimension.width * (this.zoomPercentage_ / 100.0f));
            dimension2.height = (int)((float)dimension.height * (this.zoomPercentage_ / 100.0f));
            this.pageView_.setViewSize(dimension2);
            this.updateViewer();
        } else {
            this.errorEventSupport_.fireError(new IllegalStateException());
        }
        this.workingEventSupport_.fireStopWorking();
    }

    public void pageBack() throws PropertyVetoException {
        this.setCurrentPage(this.currentPageNumber_ - 1);
        this.loadPage();
    }

    public void pageForward() throws PropertyVetoException {
        this.setCurrentPage(this.currentPageNumber_ + 1);
        this.loadPage();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
        this.initialized_ = false;
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeToolBar() {
        this.remove(this.toolBar_);
        this.validate();
    }

    public void removeStatusBar() {
        this.remove(this.statusBar_);
        this.validate();
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.removeVetoableChangeListener(vetoableChangeListener);
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public synchronized void setCurrentPage(int n) throws PropertyVetoException {
        if (1 <= n && (n <= this.numberOfPages_ || this.numberOfPagesEst_ || !this.initialized_)) {
            this.vetoableChangeSupport_.fireVetoableChange("currentPage", new Integer(this.currentPageNumber_), new Integer(n));
            int n2 = this.currentPageNumber_;
            this.currentPageNumber_ = n;
            this.propertyChangeSupport_.firePropertyChange("currentPage", new Integer(n2), new Integer(this.currentPageNumber_));
        }
    }

    public synchronized void setPaperSize(int n) throws PropertyVetoException {
        if (0 <= n && n <= 11) {
            this.vetoableChangeSupport_.fireVetoableChange("paperSize", new Integer(this.paperSize_), new Integer(n));
            int n2 = this.paperSize_;
            sPaperSize_ = this.paperSize_ = n;
            paperSizeChecked_ = true;
            this.propertyChangeSupport_.firePropertyChange("paperSize", new Integer(n2), new Integer(this.paperSize_));
        } else {
            this.errorEventSupport_.fireError(new IllegalArgumentException("paperSize"));
        }
    }

    public void setSpooledFile(SpooledFile spooledFile) throws PropertyVetoException {
        if (spooledFile == null) {
            throw new NullPointerException("spooledFile");
        }
        this.vetoableChangeSupport_.fireVetoableChange("spooledFile", this.spooledFile_, spooledFile);
        SpooledFile spooledFile2 = this.spooledFile_;
        this.spooledFile_ = spooledFile;
        this.propertyChangeSupport_.firePropertyChange("spooledFile", spooledFile2, this.spooledFile_);
    }

    public synchronized void setViewingFidelity(int n) throws PropertyVetoException {
        if (0 <= n && n <= 1) {
            this.vetoableChangeSupport_.fireVetoableChange("viewingFidelity", new Integer(this.viewingFidelity_), new Integer(n));
            int n2 = this.viewingFidelity_;
            sViewingFidelity_ = this.viewingFidelity_ = n;
            this.propertyChangeSupport_.firePropertyChange("viewingFidelity", new Integer(n2), new Integer(this.viewingFidelity_));
        } else {
            this.errorEventSupport_.fireError(new IllegalArgumentException("viewingFidelity"));
        }
    }

    private void updateViewer() {
        if (this.pageView_ != null && this.initialized_) {
            this.pageView_.repaint();
            this.zoomInfo_.setText((int)this.zoomPercentage_ + "%");
            String string = ResourceLoader.substitute(ResourceLoader.getPrintText("PAGE_OF"), new String[]{Integer.toString(this.currentPageNumber_), Integer.toString(this.numberOfPages_)});
            this.pageInfo_.setText(string + this.estimateStar_);
            if (this.currentPageNumber_ > 1) {
                this.firstPageButton_.setEnabled(true);
                this.prevPageButton_.setEnabled(true);
            } else {
                this.firstPageButton_.setEnabled(false);
                this.prevPageButton_.setEnabled(false);
            }
            if (!this.numberOfPagesEst_) {
                if (this.currentPageNumber_ < this.numberOfPages_) {
                    this.lastPageButton_.setEnabled(true);
                    this.nextPageButton_.setEnabled(true);
                } else {
                    this.lastPageButton_.setEnabled(false);
                    this.nextPageButton_.setEnabled(false);
                }
            } else {
                this.lastPageButton_.setEnabled(false);
                this.nextPageButton_.setEnabled(true);
            }
        }
    }

    private class ZoomToBox_
    extends JDialog
    implements ActionListener {
        private JButton okButton;
        private JButton cancelButton;
        private Checkbox[] radioButtons;
        private float zoomAmount;
        private TextField zoomPerc;

        public ZoomToBox_(JFrame jFrame) {
            super(jFrame, zoomText_, true);
            Container container = this.getContentPane();
            this.setResizable(false);
            container.setLayout(new BorderLayout());
            ((Component)this).setSize(250, 175);
            CheckboxGroup checkboxGroup = new CheckboxGroup();
            boolean[] blArray = new boolean[5];
            for (int i = 0; i < 5; ++i) {
                blArray[i] = false;
            }
            switch ((int)SpooledFileViewer.this.zoomPercentage_) {
                case 50: {
                    blArray[0] = true;
                    break;
                }
                case 75: {
                    blArray[1] = true;
                    break;
                }
                case 125: {
                    blArray[2] = true;
                    break;
                }
                case 150: {
                    blArray[3] = true;
                    break;
                }
                default: {
                    blArray[4] = true;
                }
            }
            this.radioButtons = new Checkbox[5];
            this.radioButtons[0] = new Checkbox(" 50%", checkboxGroup, blArray[0]);
            this.radioButtons[1] = new Checkbox(" 75%", checkboxGroup, blArray[1]);
            this.radioButtons[2] = new Checkbox("125%", checkboxGroup, blArray[2]);
            this.radioButtons[3] = new Checkbox("150%", checkboxGroup, blArray[3]);
            this.radioButtons[4] = new Checkbox("", checkboxGroup, blArray[4]);
            JPanel jPanel = new JPanel();
            container.add("West", jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(4, 1));
            jPanel2.add(this.radioButtons[0]);
            jPanel2.add(this.radioButtons[1]);
            jPanel2.add(this.radioButtons[2]);
            jPanel2.add(this.radioButtons[3]);
            container.add("Center", jPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout(2));
            this.zoomPerc = blArray[4] ? new TextField(Integer.toString((int)SpooledFileViewer.this.zoomPercentage_), 4) : new TextField("100", 4);
            this.zoomPerc.setEditable(true);
            this.zoomPerc.setBackground(new Color(255, 255, 255));
            this.zoomPerc.addActionListener(this);
            JLabel jLabel = new JLabel("%");
            jPanel3.add(this.radioButtons[4]);
            jPanel3.add(this.zoomPerc);
            jPanel3.add(jLabel);
            this.okButton = new JButton(okText_);
            this.okButton.addActionListener(this);
            this.okButton.setActionCommand("ok");
            this.cancelButton = new JButton(cancelText_);
            this.cancelButton.addActionListener(this);
            this.cancelButton.setActionCommand("cancel");
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new FlowLayout(2));
            jPanel4.add(this.okButton);
            jPanel4.add(this.cancelButton);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BorderLayout());
            jPanel5.add("Center", jPanel3);
            jPanel5.add("South", jPanel4);
            container.add("East", jPanel5);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ ZoomToBox_ this$1;
                {
                    this.this$1 = zoomToBox_;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$1.setVisible(false);
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            this.setVisible(false);
            if (!string.equals("cancel")) {
                if (this.radioButtons[0].getState()) {
                    this.zoomAmount = 0.5f;
                } else if (this.radioButtons[1].getState()) {
                    this.zoomAmount = 0.75f;
                } else if (this.radioButtons[2].getState()) {
                    this.zoomAmount = 1.25f;
                } else if (this.radioButtons[3].getState()) {
                    this.zoomAmount = 1.5f;
                } else if (this.radioButtons[4].getState()) {
                    float f = Float.valueOf(this.zoomPerc.getText()).floatValue();
                    if ((double)f >= 1.0) {
                        this.zoomAmount = (float)((double)f / 100.0);
                    } else {
                        SpooledFileViewer.this.errorEventSupport_.fireError(new IllegalArgumentException("userValue"));
                        this.zoomAmount = 0.0f;
                    }
                }
                if (this.zoomAmount > 8.0f) {
                    this.zoomAmount = 8.0f;
                }
                if (this.zoomAmount > 0.0f) {
                    Dimension dimension = SpooledFileViewer.this.getPageImageSize();
                    Dimension dimension2 = new Dimension();
                    dimension2.width = (int)((float)dimension.width * this.zoomAmount);
                    dimension2.height = (int)((float)dimension.height * this.zoomAmount);
                    SpooledFileViewer.this.pageView_.setViewSize(dimension2);
                    SpooledFileViewer.this.zoomPercentage_ = this.zoomAmount * 100.0f;
                    SpooledFileViewer.this.updateViewer();
                }
            }
        }

        public void setVisible(boolean bl) {
            if (bl) {
                Rectangle rectangle = this.getParent().getBounds();
                Rectangle rectangle2 = this.getBounds();
                ((Component)this).setLocation(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2);
                super.setVisible(true);
            } else {
                super.setVisible(false);
            }
        }
    }

    private class WarningDialogBox_
    extends JDialog
    implements ActionListener {
        JButton okButton;
        JButton cancelButton;
        String property;
        int value;

        public WarningDialogBox_(JFrame jFrame, String string, String string2, int n) {
            super(jFrame, warningText_, true);
            this.property = string2;
            this.value = n;
            this.getContentPane().setLayout(new BorderLayout());
            ((Component)this).setSize(250, 150);
            JTextArea jTextArea = new JTextArea(string);
            jTextArea.setEditable(false);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(1));
            jPanel.add(jTextArea);
            this.getContentPane().add("Center", jPanel);
            this.okButton = new JButton(okText_);
            this.okButton.addActionListener(this);
            this.okButton.setActionCommand("ok");
            this.cancelButton = new JButton(cancelText_);
            this.cancelButton.addActionListener(this);
            this.cancelButton.setActionCommand("cancel");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(1));
            jPanel2.add(this.okButton);
            jPanel2.add(this.cancelButton);
            this.getContentPane().add("South", jPanel2);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ WarningDialogBox_ this$1;
                {
                    this.this$1 = warningDialogBox_;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$1.setVisible(false);
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            this.setVisible(false);
            if (!string.equals("cancel")) {
                if (this.property.equals("viewingFidelity")) {
                    try {
                        SpooledFileViewer.this.setViewingFidelity(this.value);
                        SpooledFileViewer.this.load();
                    }
                    catch (Exception exception) {}
                } else if (this.property.equals("paperSize")) {
                    try {
                        SpooledFileViewer.this.setPaperSize(this.value);
                        SpooledFileViewer.this.load();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public void setVisible(boolean bl) {
            if (bl) {
                Rectangle rectangle = this.getParent().getBounds();
                Rectangle rectangle2 = this.getBounds();
                ((Component)this).setLocation(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2);
                super.setVisible(true);
            } else {
                super.setVisible(false);
            }
        }
    }

    private class GoToBox_
    extends JDialog
    implements ActionListener {
        JButton okButton;
        JButton cancelButton;
        TextField pageNumber;

        public GoToBox_(JFrame jFrame) {
            super(jFrame, goToPageText_, true);
            this.setResizable(false);
            this.getContentPane().setLayout(new BorderLayout());
            ((Component)this).setSize(250, 100);
            JLabel jLabel = new JLabel(goToPageText_);
            this.pageNumber = new TextField("1", 6);
            this.pageNumber.setBackground(new Color(255, 255, 255));
            this.pageNumber.setEditable(true);
            this.pageNumber.setVisible(true);
            this.pageNumber.addActionListener(this);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(1));
            jPanel.add(jLabel);
            jPanel.add(this.pageNumber);
            this.getContentPane().add("Center", jPanel);
            this.okButton = new JButton(okText_);
            this.okButton.addActionListener(this);
            this.okButton.setActionCommand("ok");
            this.cancelButton = new JButton(cancelText_);
            this.cancelButton.addActionListener(this);
            this.cancelButton.setActionCommand("cancel");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(1));
            jPanel2.add(this.okButton);
            jPanel2.add(this.cancelButton);
            this.getContentPane().add("South", jPanel2);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ GoToBox_ this$1;
                {
                    this.this$1 = goToBox_;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$1.setVisible(false);
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            this.setVisible(false);
            if (!string.equals("cancel")) {
                try {
                    SpooledFileViewer.this.setCurrentPage(Integer.valueOf(this.pageNumber.getText()));
                    SpooledFileViewer.this.loadPage();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void setVisible(boolean bl) {
            if (bl) {
                Rectangle rectangle = this.getParent().getBounds();
                Rectangle rectangle2 = this.getBounds();
                ((Component)this).setLocation(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2);
                super.setVisible(true);
            } else {
                super.setVisible(false);
            }
        }
    }

    private class ViewingFidelityBox_
    extends JDialog
    implements ActionListener {
        JButton okButton;
        JButton cancelButton;
        final JList dataList;

        public ViewingFidelityBox_(JFrame jFrame) {
            super(jFrame, vFidelityText_, true);
            this.setResizable(false);
            this.getContentPane().setLayout(new BorderLayout());
            ((Component)this).setSize(300, 175);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(1));
            jPanel.add(new JLabel(curVFidelityText_ + " : " + viewingFidelities[SpooledFileViewer.this.viewingFidelity_]));
            this.getContentPane().add("North", jPanel);
            this.dataList = new JList<String>(viewingFidelities);
            this.dataList.setSelectedIndex(SpooledFileViewer.this.viewingFidelity_);
            JScrollPane jScrollPane = new JScrollPane(this.dataList);
            this.getContentPane().add("Center", jScrollPane);
            MouseAdapter mouseAdapter = new MouseAdapter(this){
                private final /* synthetic */ ViewingFidelityBox_ this$1;
                {
                    this.this$1 = viewingFidelityBox_;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        int n = this.this$1.dataList.locationToIndex(mouseEvent.getPoint());
                        this.this$1.setVisible(false);
                        ViewingFidelityBox_.access$1500(this.this$1).displayPropertyChangeWarning("viewingFidelity", n);
                    }
                }
            };
            this.dataList.addMouseListener(mouseAdapter);
            this.okButton = new JButton(okText_);
            this.okButton.addActionListener(this);
            this.okButton.setActionCommand("ok");
            this.cancelButton = new JButton(cancelText_);
            this.cancelButton.addActionListener(this);
            this.cancelButton.setActionCommand("cancel");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(1));
            jPanel2.add(this.okButton);
            jPanel2.add(this.cancelButton);
            this.getContentPane().add("South", jPanel2);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ ViewingFidelityBox_ this$1;
                {
                    this.this$1 = viewingFidelityBox_;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$1.setVisible(false);
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            this.setVisible(false);
            if (string.equals("ok")) {
                int n = this.dataList.getSelectedIndex();
                SpooledFileViewer.this.displayPropertyChangeWarning("viewingFidelity", n);
                SpooledFileViewer.this.updateViewer();
            }
        }

        public void setVisible(boolean bl) {
            if (bl) {
                Rectangle rectangle = this.getParent().getBounds();
                Rectangle rectangle2 = this.getBounds();
                ((Component)this).setLocation(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2);
                super.setVisible(true);
            } else {
                super.setVisible(false);
            }
        }

        static /* synthetic */ SpooledFileViewer access$1500(ViewingFidelityBox_ viewingFidelityBox_) {
            return viewingFidelityBox_.SpooledFileViewer.this;
        }
    }

    private class PaperSizeBox_
    extends JDialog
    implements ActionListener {
        JButton okButton;
        JButton cancelButton;
        final JList dataList;

        public PaperSizeBox_(JFrame jFrame) {
            super(jFrame, paperSizeText_, true);
            this.setResizable(false);
            this.getContentPane().setLayout(new BorderLayout());
            ((Component)this).setSize(300, 175);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(1));
            jPanel.add(new JLabel(curPaperText_ + " : " + paperSizes[SpooledFileViewer.this.paperSize_]));
            this.getContentPane().add("North", jPanel);
            this.dataList = new JList<String>(paperSizes);
            JScrollPane jScrollPane = new JScrollPane(this.dataList);
            this.getContentPane().add("Center", jScrollPane);
            this.dataList.setSelectedIndex(SpooledFileViewer.this.paperSize_);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        int n = dataList.locationToIndex(mouseEvent.getPoint());
                        this.setVisible(false);
                        SpooledFileViewer.this.displayPropertyChangeWarning("paperSize", n);
                    }
                }
            };
            this.dataList.addMouseListener(mouseAdapter);
            this.okButton = new JButton(okText_);
            this.okButton.addActionListener(this);
            this.okButton.setActionCommand("ok");
            this.cancelButton = new JButton(cancelText_);
            this.cancelButton.addActionListener(this);
            this.cancelButton.setActionCommand("cancel");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(1));
            jPanel2.add(this.okButton);
            jPanel2.add(this.cancelButton);
            this.getContentPane().add("South", jPanel2);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ PaperSizeBox_ this$1;
                {
                    this.this$1 = paperSizeBox_;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$1.setVisible(false);
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            this.setVisible(false);
            if (string.equals("ok")) {
                int n = this.dataList.getSelectedIndex();
                SpooledFileViewer.this.displayPropertyChangeWarning("paperSize", n);
                SpooledFileViewer.this.updateViewer();
            }
        }

        public void setVisible(boolean bl) {
            if (bl) {
                Rectangle rectangle = this.getParent().getBounds();
                Rectangle rectangle2 = this.getBounds();
                ((Component)this).setLocation(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2);
                super.setVisible(true);
            } else {
                super.setVisible(false);
            }
        }
    }

    private class SpooledFilePageView_
    extends JLabel {
        Dimension viewSize_;

        public SpooledFilePageView_() {
            this.viewSize_ = new Dimension(SpooledFileViewer.this.currentPageImage_.getWidth(this), SpooledFileViewer.this.currentPageImage_.getHeight(this));
        }

        public synchronized void clearView() {
            Rectangle rectangle = this.getVisibleRect();
            this.getGraphics().clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public int getHeight() {
            if (this.viewSize_ == null) {
                return 10;
            }
            return this.viewSize_.height;
        }

        public int getWidth() {
            if (this.viewSize_ == null) {
                return 10;
            }
            return this.viewSize_.width;
        }

        public void paint(Graphics graphics) {
            graphics.drawImage(SpooledFileViewer.this.currentPageImage_, 0, 0, this.viewSize_.width, this.viewSize_.height, this);
        }

        public void setViewSize(Dimension dimension) {
            this.viewSize_.width = dimension.width;
            this.viewSize_.height = dimension.height;
        }

        public void update(Graphics graphics) {
            this.clearView();
            this.paint(graphics);
        }
    }

    private class ViewerActionListener_
    implements ActionListener {
        private ViewerActionListener_() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            try {
                if (string.equals("actualSize")) {
                    SpooledFileViewer.this.actualSize();
                } else if (string.equals("fitWidth")) {
                    SpooledFileViewer.this.fitWidth();
                } else if (string.equals("fitPage")) {
                    SpooledFileViewer.this.fitPage();
                } else if (string.equals("zoom")) {
                    SpooledFileViewer.this.changeZoom();
                } else if (string.equals("goToPage")) {
                    SpooledFileViewer.this.changeCurrentPage();
                } else if (string.equals("firstPage")) {
                    SpooledFileViewer.this.setCurrentPage(1);
                    SpooledFileViewer.this.loadPage();
                } else if (string.equals("prevPage")) {
                    SpooledFileViewer.this.pageBack();
                } else if (string.equals("nextPage")) {
                    SpooledFileViewer.this.pageForward();
                } else if (string.equals("lastPage")) {
                    SpooledFileViewer.this.setCurrentPage(SpooledFileViewer.this.numberOfPages_);
                    SpooledFileViewer.this.loadPage();
                } else if (string.equals("flashPage")) {
                    SpooledFileViewer.this.loadFlashPage();
                } else if (string.equals("changeViewingFidelity")) {
                    SpooledFileViewer.this.changeViewingFidelity();
                } else if (string.equals("changePaperSize")) {
                    SpooledFileViewer.this.changePaperSize();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

