/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.NPAttributeIFS;
import com.ibm.as400.access.Trace;
import java.io.Serializable;

abstract class NPAttribute
implements Cloneable,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    static final int TWO_BYTE = 1;
    static final int TWO_BYTE_ENU = 2;
    static final int FOUR_BYTE = 3;
    static final int FOUR_BYTE_ENU = 4;
    static final int STRING = 5;
    static final int STRING_ENU = 6;
    static final int FLOAT = 7;
    static final int PACKED_DEC = 7;
    static final int BINARY = 8;
    static final int LISTSTRING = 9;
    private int attrID_;
    private int attrType_;
    private byte[] hostData_;

    private NPAttribute() {
    }

    NPAttribute(NPAttribute nPAttribute) {
        this.attrID_ = nPAttribute.attrID_;
        this.attrType_ = nPAttribute.attrType_;
        if (nPAttribute.hostData_ != null) {
            this.hostData_ = new byte[nPAttribute.hostData_.length];
            System.arraycopy(nPAttribute.hostData_, 0, this.hostData_, 0, this.hostData_.length);
        }
    }

    NPAttribute(int n, int n2) {
        this.attrID_ = n;
        this.setType(n2);
    }

    NPAttribute(int n, int n2, byte[] byArray, int n3, int n4, ConverterImpl converterImpl) {
        this.attrID_ = n;
        this.setType(n2);
        this.hostData_ = new byte[n4];
        System.arraycopy(byArray, n3, this.hostData_, 0, n4);
    }

    protected Object clone() throws CloneNotSupportedException {
        Trace.log(2, "Clone method must be implemented in " + this.getClass().getName());
        throw new CloneNotSupportedException(this.getClass().getName());
    }

    byte[] getHostData(ConverterImpl converterImpl) {
        return this.hostData_;
    }

    int getHostLength(ConverterImpl converterImpl) {
        int n = 0;
        if (this.hostData_ != null) {
            n = this.hostData_.length;
        }
        return n;
    }

    int getID() {
        return this.attrID_;
    }

    int getType() {
        return this.attrType_;
    }

    public int hashCode() {
        return this.attrID_;
    }

    static boolean idIsValid(int n) {
        boolean bl = true;
        if (n == 0 || n > 335) {
            bl = false;
        } else if (n < 0 && (n = Math.abs(n) - 1) >= NPAttributeIFS.ifsAttrs.length) {
            bl = false;
        }
        return bl;
    }

    void setHostData(byte[] byArray, ConverterImpl converterImpl) {
        this.hostData_ = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.hostData_, 0, byArray.length);
    }

    void setType(int n) {
        this.attrType_ = n;
    }
}

