/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.math.BigInteger;
import java.util.Arrays;

public class AS400UnsignedBin8
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private static final byte[] MAX_VALUE_BYTES = new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final int SIZE = 8;
    private static final BigInteger MIN_VALUE = BigInteger.ZERO;
    private static final BigInteger MAX_VALUE = new BigInteger(MAX_VALUE_BYTES);
    private static final BigInteger DEFAULT_VALUE = BigInteger.ZERO;
    static /* synthetic */ Class class$java$math$BigInteger;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, "Unexpected cloning error", (Throwable)cloneNotSupportedException);
            throw new InternalErrorException(6);
        }
    }

    public int getByteLength() {
        return 8;
    }

    public Object getDefaultValue() {
        return DEFAULT_VALUE;
    }

    public int getInstanceType() {
        return 16;
    }

    public Class getJavaType() {
        return class$java$math$BigInteger == null ? (class$java$math$BigInteger = AS400UnsignedBin8.class$("java.math.BigInteger")) : class$java$math$BigInteger;
    }

    public byte[] toBytes(Object object) {
        byte[] byArray = new byte[8];
        this.toBytes(object, byArray, 0);
        return byArray;
    }

    public byte[] toBytes(long l) {
        byte[] byArray = new byte[8];
        this.toBytes(l, byArray, 0);
        return byArray;
    }

    public int toBytes(Object object, byte[] byArray) {
        return this.toBytes(object, byArray, 0);
    }

    public int toBytes(long l, byte[] byArray) {
        return this.toBytes(l, byArray, 0);
    }

    public int toBytes(Object object, byte[] byArray, int n) {
        BigInteger bigInteger = (BigInteger)object;
        if (bigInteger.compareTo(MIN_VALUE) < 0 || bigInteger.compareTo(MAX_VALUE) > 0) {
            throw new ExtendedIllegalArgumentException("javaValue (" + object.toString() + ")", 4);
        }
        Arrays.fill(byArray, n, n + 8, (byte)0);
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length == 9 && byArray2[0] == 0) {
            byte[] byArray3 = new byte[8];
            System.arraycopy(byArray2, 1, byArray3, 0, 8);
            byArray2 = byArray3;
        }
        int n2 = n + 8 - byArray2.length;
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return 8;
    }

    public int toBytes(long l, byte[] byArray, int n) {
        if (l < 0L) {
            throw new ExtendedIllegalArgumentException("longValue (" + l + ")", 4);
        }
        BinaryConverter.longToByteArray(l, byArray, n);
        return 8;
    }

    public Object toObject(byte[] byArray) {
        return this.toBigInteger(byArray, 0);
    }

    public Object toObject(byte[] byArray, int n) {
        return this.toBigInteger(byArray, n);
    }

    public BigInteger toBigInteger(byte[] byArray) {
        return this.toBigInteger(byArray, 0);
    }

    public BigInteger toBigInteger(byte[] byArray, int n) {
        byte[] byArray2 = new byte[9];
        byArray2[0] = 0;
        System.arraycopy(byArray, n, byArray2, 1, 8);
        return new BigInteger(byArray2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

