/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow;

import java.io.IOException;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.server.HttpUtil;
import org.apache.hop.workflow.WorkflowExecutionConfiguration;
import org.apache.hop.workflow.WorkflowMeta;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WorkflowConfiguration {
    public static final String XML_TAG = "workflow_configuration";
    private WorkflowMeta workflowMeta;
    private WorkflowExecutionConfiguration workflowExecutionConfiguration;
    private SerializableMetadataProvider metadataProvider;

    public WorkflowConfiguration(WorkflowMeta workflowMeta, WorkflowExecutionConfiguration workflowExecutionConfiguration, IHopMetadataProvider metadataProviderToEncode) throws HopException {
        this.workflowMeta = workflowMeta;
        this.workflowExecutionConfiguration = workflowExecutionConfiguration;
        this.metadataProvider = new SerializableMetadataProvider(metadataProviderToEncode);
    }

    public String getXml(IVariables variables) throws IOException, HopException {
        StringBuilder xml = new StringBuilder();
        xml.append("<workflow_configuration>").append(Const.CR);
        xml.append(this.workflowMeta.getXml(variables));
        xml.append(this.workflowExecutionConfiguration.getXml(variables));
        xml.append(XmlHandler.addTagValue((String)"metastore_json", (String)HttpUtil.encodeBase64ZippedString((String)this.metadataProvider.toJson())));
        xml.append("</workflow_configuration>").append(Const.CR);
        return xml.toString();
    }

    public WorkflowConfiguration(Node configNode, IVariables variables) throws HopException, ParseException, IOException {
        Node workflowNode = XmlHandler.getSubNode((Node)configNode, (String)"workflow");
        Node trecNode = XmlHandler.getSubNode((Node)configNode, (String)"workflow_execution_configuration");
        this.workflowExecutionConfiguration = new WorkflowExecutionConfiguration(trecNode);
        String metaStoreJson = HttpUtil.decodeBase64ZippedString((String)XmlHandler.getTagValue((Node)configNode, (String)"metastore_json"));
        this.metadataProvider = new SerializableMetadataProvider(metaStoreJson);
        this.workflowMeta = new WorkflowMeta(workflowNode, (IHopMetadataProvider)this.metadataProvider, variables);
    }

    public static final WorkflowConfiguration fromXml(String xml, IVariables variables) throws HopException, ParseException, IOException {
        Document document = XmlHandler.loadXmlString((String)xml);
        Node configNode = XmlHandler.getSubNode((Node)document, (String)XML_TAG);
        return new WorkflowConfiguration(configNode, variables);
    }

    public WorkflowExecutionConfiguration getWorkflowExecutionConfiguration() {
        return this.workflowExecutionConfiguration;
    }

    public void setWorkflowExecutionConfiguration(WorkflowExecutionConfiguration workflowExecutionConfiguration) {
        this.workflowExecutionConfiguration = workflowExecutionConfiguration;
    }

    public WorkflowMeta getWorkflowMeta() {
        return this.workflowMeta;
    }

    public void setWorkflowMeta(WorkflowMeta workflowMeta) {
        this.workflowMeta = workflowMeta;
    }

    public SerializableMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }
}

