/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.sharing.AccessInheritance;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.sharing.FolderPermission;
import com.dropbox.core.v2.sharing.FolderPolicy;
import com.dropbox.core.v2.sharing.SharedContentLinkMetadata;
import com.dropbox.core.v2.sharing.SharedFolderMetadataBase;
import com.dropbox.core.v2.users.Team;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class SharedFolderMetadata
extends SharedFolderMetadataBase {
    protected final SharedContentLinkMetadata linkMetadata;
    protected final String name;
    protected final List<FolderPermission> permissions;
    protected final FolderPolicy policy;
    protected final String previewUrl;
    protected final String sharedFolderId;
    protected final Date timeInvited;
    protected final AccessInheritance accessInheritance;

    public SharedFolderMetadata(AccessLevel accessType, boolean isInsideTeamFolder, boolean isTeamFolder, String name, FolderPolicy policy, String previewUrl, String sharedFolderId, Date timeInvited, List<String> ownerDisplayNames, Team ownerTeam, String parentSharedFolderId, String pathLower, String parentFolderName, SharedContentLinkMetadata linkMetadata, List<FolderPermission> permissions, AccessInheritance accessInheritance) {
        super(accessType, isInsideTeamFolder, isTeamFolder, ownerDisplayNames, ownerTeam, parentSharedFolderId, pathLower, parentFolderName);
        this.linkMetadata = linkMetadata;
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        if (permissions != null) {
            for (FolderPermission x : permissions) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'permissions' is null");
            }
        }
        this.permissions = permissions;
        if (policy == null) {
            throw new IllegalArgumentException("Required value for 'policy' is null");
        }
        this.policy = policy;
        if (previewUrl == null) {
            throw new IllegalArgumentException("Required value for 'previewUrl' is null");
        }
        this.previewUrl = previewUrl;
        if (sharedFolderId == null) {
            throw new IllegalArgumentException("Required value for 'sharedFolderId' is null");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
            throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
        }
        this.sharedFolderId = sharedFolderId;
        if (timeInvited == null) {
            throw new IllegalArgumentException("Required value for 'timeInvited' is null");
        }
        this.timeInvited = LangUtil.truncateMillis(timeInvited);
        if (accessInheritance == null) {
            throw new IllegalArgumentException("Required value for 'accessInheritance' is null");
        }
        this.accessInheritance = accessInheritance;
    }

    public SharedFolderMetadata(AccessLevel accessType, boolean isInsideTeamFolder, boolean isTeamFolder, String name, FolderPolicy policy, String previewUrl, String sharedFolderId, Date timeInvited) {
        this(accessType, isInsideTeamFolder, isTeamFolder, name, policy, previewUrl, sharedFolderId, timeInvited, null, null, null, null, null, null, null, AccessInheritance.INHERIT);
    }

    @Override
    public AccessLevel getAccessType() {
        return this.accessType;
    }

    @Override
    public boolean getIsInsideTeamFolder() {
        return this.isInsideTeamFolder;
    }

    @Override
    public boolean getIsTeamFolder() {
        return this.isTeamFolder;
    }

    public String getName() {
        return this.name;
    }

    public FolderPolicy getPolicy() {
        return this.policy;
    }

    public String getPreviewUrl() {
        return this.previewUrl;
    }

    public String getSharedFolderId() {
        return this.sharedFolderId;
    }

    public Date getTimeInvited() {
        return this.timeInvited;
    }

    @Override
    public List<String> getOwnerDisplayNames() {
        return this.ownerDisplayNames;
    }

    @Override
    public Team getOwnerTeam() {
        return this.ownerTeam;
    }

    @Override
    public String getParentSharedFolderId() {
        return this.parentSharedFolderId;
    }

    @Override
    public String getPathLower() {
        return this.pathLower;
    }

    @Override
    public String getParentFolderName() {
        return this.parentFolderName;
    }

    public SharedContentLinkMetadata getLinkMetadata() {
        return this.linkMetadata;
    }

    public List<FolderPermission> getPermissions() {
        return this.permissions;
    }

    public AccessInheritance getAccessInheritance() {
        return this.accessInheritance;
    }

    public static Builder newBuilder(AccessLevel accessType, boolean isInsideTeamFolder, boolean isTeamFolder, String name, FolderPolicy policy, String previewUrl, String sharedFolderId, Date timeInvited) {
        return new Builder(accessType, isInsideTeamFolder, isTeamFolder, name, policy, previewUrl, sharedFolderId, timeInvited);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.linkMetadata, this.name, this.permissions, this.policy, this.previewUrl, this.sharedFolderId, this.timeInvited, this.accessInheritance});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedFolderMetadata other = (SharedFolderMetadata)obj;
            return !(this.accessType != other.accessType && !this.accessType.equals((Object)other.accessType) || this.isInsideTeamFolder != other.isInsideTeamFolder || this.isTeamFolder != other.isTeamFolder || this.name != other.name && !this.name.equals(other.name) || this.policy != other.policy && !this.policy.equals(other.policy) || this.previewUrl != other.previewUrl && !this.previewUrl.equals(other.previewUrl) || this.sharedFolderId != other.sharedFolderId && !this.sharedFolderId.equals(other.sharedFolderId) || this.timeInvited != other.timeInvited && !this.timeInvited.equals(other.timeInvited) || this.ownerDisplayNames != other.ownerDisplayNames && (this.ownerDisplayNames == null || !this.ownerDisplayNames.equals(other.ownerDisplayNames)) || this.ownerTeam != other.ownerTeam && (this.ownerTeam == null || !this.ownerTeam.equals(other.ownerTeam)) || this.parentSharedFolderId != other.parentSharedFolderId && (this.parentSharedFolderId == null || !this.parentSharedFolderId.equals(other.parentSharedFolderId)) || this.pathLower != other.pathLower && (this.pathLower == null || !this.pathLower.equals(other.pathLower)) || this.parentFolderName != other.parentFolderName && (this.parentFolderName == null || !this.parentFolderName.equals(other.parentFolderName)) || this.linkMetadata != other.linkMetadata && (this.linkMetadata == null || !this.linkMetadata.equals(other.linkMetadata)) || this.permissions != other.permissions && (this.permissions == null || !this.permissions.equals(other.permissions)) || this.accessInheritance != other.accessInheritance && !this.accessInheritance.equals((Object)other.accessInheritance));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SharedFolderMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharedFolderMetadata value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("access_type");
            AccessLevel.Serializer.INSTANCE.serialize(value.accessType, g);
            g.writeFieldName("is_inside_team_folder");
            StoneSerializers.boolean_().serialize((Boolean)value.isInsideTeamFolder, g);
            g.writeFieldName("is_team_folder");
            StoneSerializers.boolean_().serialize((Boolean)value.isTeamFolder, g);
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            g.writeFieldName("policy");
            FolderPolicy.Serializer.INSTANCE.serialize(value.policy, g);
            g.writeFieldName("preview_url");
            StoneSerializers.string().serialize(value.previewUrl, g);
            g.writeFieldName("shared_folder_id");
            StoneSerializers.string().serialize(value.sharedFolderId, g);
            g.writeFieldName("time_invited");
            StoneSerializers.timestamp().serialize(value.timeInvited, g);
            if (value.ownerDisplayNames != null) {
                g.writeFieldName("owner_display_names");
                StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).serialize((List<String>)value.ownerDisplayNames, g);
            }
            if (value.ownerTeam != null) {
                g.writeFieldName("owner_team");
                StoneSerializers.nullableStruct(Team.Serializer.INSTANCE).serialize(value.ownerTeam, g);
            }
            if (value.parentSharedFolderId != null) {
                g.writeFieldName("parent_shared_folder_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.parentSharedFolderId, g);
            }
            if (value.pathLower != null) {
                g.writeFieldName("path_lower");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.pathLower, g);
            }
            if (value.parentFolderName != null) {
                g.writeFieldName("parent_folder_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.parentFolderName, g);
            }
            if (value.linkMetadata != null) {
                g.writeFieldName("link_metadata");
                StoneSerializers.nullableStruct(SharedContentLinkMetadata.Serializer.INSTANCE).serialize(value.linkMetadata, g);
            }
            if (value.permissions != null) {
                g.writeFieldName("permissions");
                StoneSerializers.nullable(StoneSerializers.list(FolderPermission.Serializer.INSTANCE)).serialize(value.permissions, g);
            }
            g.writeFieldName("access_inheritance");
            AccessInheritance.Serializer.INSTANCE.serialize(value.accessInheritance, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SharedFolderMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            AccessInheritance f_accessInheritance;
            List<FolderPermission> f_permissions;
            SharedContentLinkMetadata f_linkMetadata;
            String f_parentFolderName;
            String f_pathLower;
            String f_parentSharedFolderId;
            Team f_ownerTeam;
            List<String> f_ownerDisplayNames;
            Date f_timeInvited;
            String f_sharedFolderId;
            String f_previewUrl;
            FolderPolicy f_policy;
            String f_name;
            Boolean f_isTeamFolder;
            Boolean f_isInsideTeamFolder;
            AccessLevel f_accessType;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_accessType = null;
                f_isInsideTeamFolder = null;
                f_isTeamFolder = null;
                f_name = null;
                f_policy = null;
                f_previewUrl = null;
                f_sharedFolderId = null;
                f_timeInvited = null;
                f_ownerDisplayNames = null;
                f_ownerTeam = null;
                f_parentSharedFolderId = null;
                f_pathLower = null;
                f_parentFolderName = null;
                f_linkMetadata = null;
                f_permissions = null;
                f_accessInheritance = AccessInheritance.INHERIT;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("access_type".equals(field)) {
                        f_accessType = AccessLevel.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("is_inside_team_folder".equals(field)) {
                        f_isInsideTeamFolder = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("is_team_folder".equals(field)) {
                        f_isTeamFolder = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("policy".equals(field)) {
                        f_policy = (FolderPolicy)FolderPolicy.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("preview_url".equals(field)) {
                        f_previewUrl = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("shared_folder_id".equals(field)) {
                        f_sharedFolderId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("time_invited".equals(field)) {
                        f_timeInvited = StoneSerializers.timestamp().deserialize(p);
                        continue;
                    }
                    if ("owner_display_names".equals(field)) {
                        f_ownerDisplayNames = StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).deserialize(p);
                        continue;
                    }
                    if ("owner_team".equals(field)) {
                        f_ownerTeam = StoneSerializers.nullableStruct(Team.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("parent_shared_folder_id".equals(field)) {
                        f_parentSharedFolderId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("path_lower".equals(field)) {
                        f_pathLower = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("parent_folder_name".equals(field)) {
                        f_parentFolderName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("link_metadata".equals(field)) {
                        f_linkMetadata = StoneSerializers.nullableStruct(SharedContentLinkMetadata.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("permissions".equals(field)) {
                        f_permissions = StoneSerializers.nullable(StoneSerializers.list(FolderPermission.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    if ("access_inheritance".equals(field)) {
                        f_accessInheritance = AccessInheritance.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_accessType == null) {
                    throw new JsonParseException(p, "Required field \"access_type\" missing.");
                }
                if (f_isInsideTeamFolder == null) {
                    throw new JsonParseException(p, "Required field \"is_inside_team_folder\" missing.");
                }
                if (f_isTeamFolder == null) {
                    throw new JsonParseException(p, "Required field \"is_team_folder\" missing.");
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_policy == null) {
                    throw new JsonParseException(p, "Required field \"policy\" missing.");
                }
                if (f_previewUrl == null) {
                    throw new JsonParseException(p, "Required field \"preview_url\" missing.");
                }
                if (f_sharedFolderId == null) {
                    throw new JsonParseException(p, "Required field \"shared_folder_id\" missing.");
                }
                if (f_timeInvited == null) {
                    throw new JsonParseException(p, "Required field \"time_invited\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharedFolderMetadata value = new SharedFolderMetadata(f_accessType, f_isInsideTeamFolder, f_isTeamFolder, f_name, f_policy, f_previewUrl, f_sharedFolderId, f_timeInvited, f_ownerDisplayNames, f_ownerTeam, f_parentSharedFolderId, f_pathLower, f_parentFolderName, f_linkMetadata, f_permissions, f_accessInheritance);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder
    extends SharedFolderMetadataBase.Builder {
        protected final String name;
        protected final FolderPolicy policy;
        protected final String previewUrl;
        protected final String sharedFolderId;
        protected final Date timeInvited;
        protected SharedContentLinkMetadata linkMetadata;
        protected List<FolderPermission> permissions;
        protected AccessInheritance accessInheritance;

        protected Builder(AccessLevel accessType, boolean isInsideTeamFolder, boolean isTeamFolder, String name, FolderPolicy policy, String previewUrl, String sharedFolderId, Date timeInvited) {
            super(accessType, isInsideTeamFolder, isTeamFolder);
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            if (policy == null) {
                throw new IllegalArgumentException("Required value for 'policy' is null");
            }
            this.policy = policy;
            if (previewUrl == null) {
                throw new IllegalArgumentException("Required value for 'previewUrl' is null");
            }
            this.previewUrl = previewUrl;
            if (sharedFolderId == null) {
                throw new IllegalArgumentException("Required value for 'sharedFolderId' is null");
            }
            if (!Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
                throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
            }
            this.sharedFolderId = sharedFolderId;
            if (timeInvited == null) {
                throw new IllegalArgumentException("Required value for 'timeInvited' is null");
            }
            this.timeInvited = LangUtil.truncateMillis(timeInvited);
            this.linkMetadata = null;
            this.permissions = null;
            this.accessInheritance = AccessInheritance.INHERIT;
        }

        public Builder withLinkMetadata(SharedContentLinkMetadata linkMetadata) {
            this.linkMetadata = linkMetadata;
            return this;
        }

        public Builder withPermissions(List<FolderPermission> permissions) {
            if (permissions != null) {
                for (FolderPermission x : permissions) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'permissions' is null");
                }
            }
            this.permissions = permissions;
            return this;
        }

        public Builder withAccessInheritance(AccessInheritance accessInheritance) {
            this.accessInheritance = accessInheritance != null ? accessInheritance : AccessInheritance.INHERIT;
            return this;
        }

        @Override
        public Builder withOwnerDisplayNames(List<String> ownerDisplayNames) {
            super.withOwnerDisplayNames(ownerDisplayNames);
            return this;
        }

        @Override
        public Builder withOwnerTeam(Team ownerTeam) {
            super.withOwnerTeam(ownerTeam);
            return this;
        }

        @Override
        public Builder withParentSharedFolderId(String parentSharedFolderId) {
            super.withParentSharedFolderId(parentSharedFolderId);
            return this;
        }

        @Override
        public Builder withPathLower(String pathLower) {
            super.withPathLower(pathLower);
            return this;
        }

        @Override
        public Builder withParentFolderName(String parentFolderName) {
            super.withParentFolderName(parentFolderName);
            return this;
        }

        @Override
        public SharedFolderMetadata build() {
            return new SharedFolderMetadata(this.accessType, this.isInsideTeamFolder, this.isTeamFolder, this.name, this.policy, this.previewUrl, this.sharedFolderId, this.timeInvited, this.ownerDisplayNames, this.ownerTeam, this.parentSharedFolderId, this.pathLower, this.parentFolderName, this.linkMetadata, this.permissions, this.accessInheritance);
        }
    }
}

