/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class ExportInfo {
    protected final String exportAs;

    public ExportInfo(String exportAs) {
        this.exportAs = exportAs;
    }

    public ExportInfo() {
        this(null);
    }

    public String getExportAs() {
        return this.exportAs;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.exportAs});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ExportInfo other = (ExportInfo)obj;
            return this.exportAs == other.exportAs || this.exportAs != null && this.exportAs.equals(other.exportAs);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ExportInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ExportInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.exportAs != null) {
                g.writeFieldName("export_as");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.exportAs, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public ExportInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_exportAs;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_exportAs = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("export_as".equals(field)) {
                        f_exportAs = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ExportInfo value = new ExportInfo(f_exportAs);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

