/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class UserInfo {
    protected final String id;
    protected final String email;

    public UserInfo(String id, String email) {
        if (id == null) {
            throw new IllegalArgumentException("Required value for 'id' is null");
        }
        this.id = id;
        if (email == null) {
            throw new IllegalArgumentException("Required value for 'email' is null");
        }
        this.email = email;
    }

    public UserInfo() {
        this("\"\"", "\"\"");
    }

    public String getId() {
        return this.id;
    }

    public String getEmail() {
        return this.email;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.id, this.email});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UserInfo other = (UserInfo)obj;
            return !(this.id != other.id && !this.id.equals(other.id) || this.email != other.email && !this.email.equals(other.email));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UserInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UserInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("id");
            StoneSerializers.string().serialize(value.id, g);
            g.writeFieldName("email");
            StoneSerializers.string().serialize(value.email, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UserInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_email;
            String f_id;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_id = "\"\"";
                f_email = "\"\"";
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("id".equals(field)) {
                        f_id = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("email".equals(field)) {
                        f_email = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UserInfo value = new UserInfo(f_id, f_email);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected String id = "\"\"";
        protected String email = "\"\"";

        protected Builder() {
        }

        public Builder withId(String id) {
            this.id = id != null ? id : "\"\"";
            return this;
        }

        public Builder withEmail(String email) {
            this.email = email != null ? email : "\"\"";
            return this;
        }

        public UserInfo build() {
            return new UserInfo(this.id, this.email);
        }
    }
}

