/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.kafka.DeserializerProvider;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.io.kafka.TimestampPolicyFactory;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.PORTABILITY)
final class AutoValue_KafkaIO_ReadSourceDescriptors<K, V>
extends KafkaIO.ReadSourceDescriptors<K, V> {
    private final Map<String, Object> consumerConfig;
    private final @Nullable Map<String, Object> offsetConsumerConfig;
    private final @Nullable DeserializerProvider keyDeserializerProvider;
    private final @Nullable DeserializerProvider valueDeserializerProvider;
    private final @Nullable Coder<K> keyCoder;
    private final @Nullable Coder<V> valueCoder;
    private final SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn;
    private final @Nullable SerializableFunction<TopicPartition, Boolean> checkStopReadingFn;
    private final @Nullable SerializableFunction<KafkaRecord<K, V>, Instant> extractOutputTimestampFn;
    private final @Nullable SerializableFunction<Instant, WatermarkEstimator<Instant>> createWatermarkEstimatorFn;
    private final boolean commitOffsetEnabled;
    private final @Nullable TimestampPolicyFactory<K, V> timestampPolicyFactory;
    private final boolean bounded;

    private AutoValue_KafkaIO_ReadSourceDescriptors(Map<String, Object> consumerConfig, @Nullable Map<String, Object> offsetConsumerConfig, @Nullable DeserializerProvider keyDeserializerProvider, @Nullable DeserializerProvider valueDeserializerProvider, @Nullable Coder<K> keyCoder, @Nullable Coder<V> valueCoder, SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn, @Nullable SerializableFunction<TopicPartition, Boolean> checkStopReadingFn, @Nullable SerializableFunction<KafkaRecord<K, V>, Instant> extractOutputTimestampFn, @Nullable SerializableFunction<Instant, WatermarkEstimator<Instant>> createWatermarkEstimatorFn, boolean commitOffsetEnabled, @Nullable TimestampPolicyFactory<K, V> timestampPolicyFactory, boolean bounded) {
        this.consumerConfig = consumerConfig;
        this.offsetConsumerConfig = offsetConsumerConfig;
        this.keyDeserializerProvider = keyDeserializerProvider;
        this.valueDeserializerProvider = valueDeserializerProvider;
        this.keyCoder = keyCoder;
        this.valueCoder = valueCoder;
        this.consumerFactoryFn = consumerFactoryFn;
        this.checkStopReadingFn = checkStopReadingFn;
        this.extractOutputTimestampFn = extractOutputTimestampFn;
        this.createWatermarkEstimatorFn = createWatermarkEstimatorFn;
        this.commitOffsetEnabled = commitOffsetEnabled;
        this.timestampPolicyFactory = timestampPolicyFactory;
        this.bounded = bounded;
    }

    @Override
    @Pure
    Map<String, Object> getConsumerConfig() {
        return this.consumerConfig;
    }

    @Override
    @Pure
    @Nullable Map<String, Object> getOffsetConsumerConfig() {
        return this.offsetConsumerConfig;
    }

    @Override
    @Pure
    @Nullable DeserializerProvider getKeyDeserializerProvider() {
        return this.keyDeserializerProvider;
    }

    @Override
    @Pure
    @Nullable DeserializerProvider getValueDeserializerProvider() {
        return this.valueDeserializerProvider;
    }

    @Override
    @Pure
    @Nullable Coder<K> getKeyCoder() {
        return this.keyCoder;
    }

    @Override
    @Pure
    @Nullable Coder<V> getValueCoder() {
        return this.valueCoder;
    }

    @Override
    @Pure
    SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> getConsumerFactoryFn() {
        return this.consumerFactoryFn;
    }

    @Override
    @Pure
    @Nullable SerializableFunction<TopicPartition, Boolean> getCheckStopReadingFn() {
        return this.checkStopReadingFn;
    }

    @Override
    @Pure
    @Nullable SerializableFunction<KafkaRecord<K, V>, Instant> getExtractOutputTimestampFn() {
        return this.extractOutputTimestampFn;
    }

    @Override
    @Pure
    @Nullable SerializableFunction<Instant, WatermarkEstimator<Instant>> getCreateWatermarkEstimatorFn() {
        return this.createWatermarkEstimatorFn;
    }

    @Override
    @Pure
    boolean isCommitOffsetEnabled() {
        return this.commitOffsetEnabled;
    }

    @Override
    @Pure
    @Nullable TimestampPolicyFactory<K, V> getTimestampPolicyFactory() {
        return this.timestampPolicyFactory;
    }

    @Override
    boolean isBounded() {
        return this.bounded;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KafkaIO.ReadSourceDescriptors) {
            KafkaIO.ReadSourceDescriptors that = (KafkaIO.ReadSourceDescriptors)((Object)o);
            return this.consumerConfig.equals(that.getConsumerConfig()) && (this.offsetConsumerConfig == null ? that.getOffsetConsumerConfig() == null : this.offsetConsumerConfig.equals(that.getOffsetConsumerConfig())) && (this.keyDeserializerProvider == null ? that.getKeyDeserializerProvider() == null : this.keyDeserializerProvider.equals(that.getKeyDeserializerProvider())) && (this.valueDeserializerProvider == null ? that.getValueDeserializerProvider() == null : this.valueDeserializerProvider.equals(that.getValueDeserializerProvider())) && (this.keyCoder == null ? that.getKeyCoder() == null : this.keyCoder.equals(that.getKeyCoder())) && (this.valueCoder == null ? that.getValueCoder() == null : this.valueCoder.equals(that.getValueCoder())) && this.consumerFactoryFn.equals(that.getConsumerFactoryFn()) && (this.checkStopReadingFn == null ? that.getCheckStopReadingFn() == null : this.checkStopReadingFn.equals(that.getCheckStopReadingFn())) && (this.extractOutputTimestampFn == null ? that.getExtractOutputTimestampFn() == null : this.extractOutputTimestampFn.equals(that.getExtractOutputTimestampFn())) && (this.createWatermarkEstimatorFn == null ? that.getCreateWatermarkEstimatorFn() == null : this.createWatermarkEstimatorFn.equals(that.getCreateWatermarkEstimatorFn())) && this.commitOffsetEnabled == that.isCommitOffsetEnabled() && (this.timestampPolicyFactory == null ? that.getTimestampPolicyFactory() == null : this.timestampPolicyFactory.equals(that.getTimestampPolicyFactory())) && this.bounded == that.isBounded();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.consumerConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.offsetConsumerConfig == null ? 0 : this.offsetConsumerConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.keyDeserializerProvider == null ? 0 : this.keyDeserializerProvider.hashCode();
        h$ *= 1000003;
        h$ ^= this.valueDeserializerProvider == null ? 0 : this.valueDeserializerProvider.hashCode();
        h$ *= 1000003;
        h$ ^= this.keyCoder == null ? 0 : this.keyCoder.hashCode();
        h$ *= 1000003;
        h$ ^= this.valueCoder == null ? 0 : this.valueCoder.hashCode();
        h$ *= 1000003;
        h$ ^= this.consumerFactoryFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.checkStopReadingFn == null ? 0 : this.checkStopReadingFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.extractOutputTimestampFn == null ? 0 : this.extractOutputTimestampFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.createWatermarkEstimatorFn == null ? 0 : this.createWatermarkEstimatorFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.commitOffsetEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.timestampPolicyFactory == null ? 0 : this.timestampPolicyFactory.hashCode();
        h$ *= 1000003;
        return h$ ^= this.bounded ? 1231 : 1237;
    }

    @Override
    KafkaIO.ReadSourceDescriptors.Builder<K, V> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<K, V>
    extends KafkaIO.ReadSourceDescriptors.Builder<K, V> {
        private Map<String, Object> consumerConfig;
        private @Nullable Map<String, Object> offsetConsumerConfig;
        private @Nullable DeserializerProvider keyDeserializerProvider;
        private @Nullable DeserializerProvider valueDeserializerProvider;
        private @Nullable Coder<K> keyCoder;
        private @Nullable Coder<V> valueCoder;
        private SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn;
        private @Nullable SerializableFunction<TopicPartition, Boolean> checkStopReadingFn;
        private @Nullable SerializableFunction<KafkaRecord<K, V>, Instant> extractOutputTimestampFn;
        private @Nullable SerializableFunction<Instant, WatermarkEstimator<Instant>> createWatermarkEstimatorFn;
        private Boolean commitOffsetEnabled;
        private @Nullable TimestampPolicyFactory<K, V> timestampPolicyFactory;
        private Boolean bounded;

        Builder() {
        }

        private Builder(KafkaIO.ReadSourceDescriptors<K, V> source) {
            this.consumerConfig = source.getConsumerConfig();
            this.offsetConsumerConfig = source.getOffsetConsumerConfig();
            this.keyDeserializerProvider = source.getKeyDeserializerProvider();
            this.valueDeserializerProvider = source.getValueDeserializerProvider();
            this.keyCoder = source.getKeyCoder();
            this.valueCoder = source.getValueCoder();
            this.consumerFactoryFn = source.getConsumerFactoryFn();
            this.checkStopReadingFn = source.getCheckStopReadingFn();
            this.extractOutputTimestampFn = source.getExtractOutputTimestampFn();
            this.createWatermarkEstimatorFn = source.getCreateWatermarkEstimatorFn();
            this.commitOffsetEnabled = source.isCommitOffsetEnabled();
            this.timestampPolicyFactory = source.getTimestampPolicyFactory();
            this.bounded = source.isBounded();
        }

        @Override
        KafkaIO.ReadSourceDescriptors.Builder<K, V> setConsumerConfig(Map<String, Object> consumerConfig) {
            if (consumerConfig == null) {
                throw new NullPointerException("Null consumerConfig");
            }
            this.consumerConfig = consumerConfig;
            return this;
        }

        @Override
        KafkaIO.ReadSourceDescriptors.Builder<K, V> setOffsetConsumerConfig(@Nullable Map<String, Object> offsetConsumerConfig) {
            this.offsetConsumerConfig = offsetConsumerConfig;
            return this;
        }

        @Override
        KafkaIO.ReadSourceDescriptors.Builder<K, V> setKeyDeserializerProvider(@Nullable DeserializerProvider keyDeserializerProvider) {
            this.keyDeserializerProvider = keyDeserializerProvider;
            return this;
        }

        @Override
        KafkaIO.ReadSourceDescriptors.Builder<K, V> setValueDeserializerProvider(@Nullable DeserializerProvider valueDeserializerProvider) {
            this.valueDeserializerProvider = valueDeserializerProvider;
            return this;
        }

        @Override
        KafkaIO.ReadSourceDescriptors.Builder<K, V> setKeyCoder(Coder<K> keyCoder) {
            this.keyCoder = keyCoder;
            return this;
        }

        @Override
        KafkaIO.ReadSourceDescriptors.Builder<K, V> setValueCoder(Coder<V> valueCoder) {
            this.valueCoder = valueCoder;
            return this;
        }

        @Override
        KafkaIO.ReadSourceDescriptors.Builder<K, V> setConsumerFactoryFn(SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn) {
            if (consumerFactoryFn == null) {
                throw new NullPointerException("Null consumerFactoryFn");
            }
            this.consumerFactoryFn = consumerFactoryFn;
            return this;
        }

        @Override
        KafkaIO.ReadSourceDescriptors.Builder<K, V> setCheckStopReadingFn(@Nullable SerializableFunction<TopicPartition, Boolean> checkStopReadingFn) {
            this.checkStopReadingFn = checkStopReadingFn;
            return this;
        }

        @Override
        KafkaIO.ReadSourceDescriptors.Builder<K, V> setExtractOutputTimestampFn(SerializableFunction<KafkaRecord<K, V>, Instant> extractOutputTimestampFn) {
            this.extractOutputTimestampFn = extractOutputTimestampFn;
            return this;
        }

        @Override
        KafkaIO.ReadSourceDescriptors.Builder<K, V> setCreateWatermarkEstimatorFn(SerializableFunction<Instant, WatermarkEstimator<Instant>> createWatermarkEstimatorFn) {
            this.createWatermarkEstimatorFn = createWatermarkEstimatorFn;
            return this;
        }

        @Override
        KafkaIO.ReadSourceDescriptors.Builder<K, V> setCommitOffsetEnabled(boolean commitOffsetEnabled) {
            this.commitOffsetEnabled = commitOffsetEnabled;
            return this;
        }

        @Override
        KafkaIO.ReadSourceDescriptors.Builder<K, V> setTimestampPolicyFactory(TimestampPolicyFactory<K, V> timestampPolicyFactory) {
            this.timestampPolicyFactory = timestampPolicyFactory;
            return this;
        }

        @Override
        KafkaIO.ReadSourceDescriptors.Builder<K, V> setBounded(boolean bounded) {
            this.bounded = bounded;
            return this;
        }

        @Override
        KafkaIO.ReadSourceDescriptors<K, V> build() {
            if (this.consumerConfig == null || this.consumerFactoryFn == null || this.commitOffsetEnabled == null || this.bounded == null) {
                StringBuilder missing = new StringBuilder();
                if (this.consumerConfig == null) {
                    missing.append(" consumerConfig");
                }
                if (this.consumerFactoryFn == null) {
                    missing.append(" consumerFactoryFn");
                }
                if (this.commitOffsetEnabled == null) {
                    missing.append(" commitOffsetEnabled");
                }
                if (this.bounded == null) {
                    missing.append(" bounded");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KafkaIO_ReadSourceDescriptors(this.consumerConfig, this.offsetConsumerConfig, this.keyDeserializerProvider, this.valueDeserializerProvider, this.keyCoder, this.valueCoder, this.consumerFactoryFn, this.checkStopReadingFn, this.extractOutputTimestampFn, this.createWatermarkEstimatorFn, this.commitOffsetEnabled, this.timestampPolicyFactory, this.bounded);
        }
    }
}

