/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ColumnarStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ProtocolBuffersStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ReflectionStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ThriftStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ThriftUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.thrift.TUnion;

public final class ObjectInspectorFactory {
    private static CacheBuilder<Object, Object> boundedBuilder = CacheBuilder.newBuilder().initialCapacity(1024).maximumSize(10240L).concurrencyLevel(Runtime.getRuntime().availableProcessors()).expireAfterAccess(5L, TimeUnit.MINUTES).softValues();
    private static CacheBuilder<Object, Object> unboundedBuilder = CacheBuilder.newBuilder().initialCapacity(1024).concurrencyLevel(Runtime.getRuntime().availableProcessors()).expireAfterAccess(5L, TimeUnit.MINUTES).softValues();
    static Cache<Type, ObjectInspector> objectInspectorCache = unboundedBuilder.build();
    static Cache<List<StructObjectInspector>, UnionStructObjectInspector> cachedUnionStructObjectInspector = boundedBuilder.build();
    static Cache<ObjectInspector, StandardListObjectInspector> cachedStandardListObjectInspector = boundedBuilder.build();
    static Cache<List<ObjectInspector>, StandardMapObjectInspector> cachedStandardMapObjectInspector = boundedBuilder.build();
    static Cache<List<ObjectInspector>, StandardUnionObjectInspector> cachedStandardUnionObjectInspector = boundedBuilder.build();
    static Cache<ArrayList<List<?>>, StandardStructObjectInspector> cachedStandardStructObjectInspector = boundedBuilder.build();
    static Cache<ArrayList<Object>, ColumnarStructObjectInspector> cachedColumnarStructObjectInspector = boundedBuilder.build();

    public static ObjectInspector getReflectionObjectInspector(Type t, ObjectInspectorOptions options) {
        return ObjectInspectorFactory.getReflectionObjectInspector(t, options, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectInspector getReflectionObjectInspector(Type t, ObjectInspectorOptions options, boolean ensureInited) {
        ObjectInspector oi = (ObjectInspector)objectInspectorCache.asMap().get(t);
        if (oi == null) {
            oi = ObjectInspectorFactory.getReflectionObjectInspectorNoCache(t, options, ensureInited);
            ObjectInspector prev = objectInspectorCache.asMap().putIfAbsent(t, oi);
            if (prev != null) {
                oi = prev;
            }
        }
        if (ensureInited && oi instanceof ReflectionStructObjectInspector) {
            ReflectionStructObjectInspector soi;
            ReflectionStructObjectInspector reflectionStructObjectInspector = soi = (ReflectionStructObjectInspector)oi;
            synchronized (reflectionStructObjectInspector) {
                HashSet<Type> checkedTypes = new HashSet<Type>();
                while (!soi.isFullyInited(checkedTypes)) {
                    try {
                        soi.wait(3000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Interrupted while waiting for " + soi.getClass().getName() + " to initialize", e);
                    }
                }
            }
        }
        ObjectInspectorFactory.verifyObjectInspector(options, oi, ObjectInspectorOptions.JAVA, new Class[]{ThriftStructObjectInspector.class, ProtocolBuffersStructObjectInspector.class});
        ObjectInspectorFactory.verifyObjectInspector(options, oi, ObjectInspectorOptions.THRIFT, new Class[]{ReflectionStructObjectInspector.class, ProtocolBuffersStructObjectInspector.class});
        ObjectInspectorFactory.verifyObjectInspector(options, oi, ObjectInspectorOptions.PROTOCOL_BUFFERS, new Class[]{ThriftStructObjectInspector.class, ReflectionStructObjectInspector.class});
        return oi;
    }

    private static void verifyObjectInspector(ObjectInspectorOptions option, ObjectInspector oi, ObjectInspectorOptions checkOption, Class<?>[] classes) {
        if (option.equals((Object)checkOption)) {
            for (Class<?> checkClass : classes) {
                if (!oi.getClass().equals(checkClass)) continue;
                throw new RuntimeException("Cannot call getObjectInspectorByReflection with more then one of " + Arrays.toString((Object[])ObjectInspectorOptions.values()) + "!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectInspector getReflectionObjectInspectorNoCache(Type t, ObjectInspectorOptions options, boolean ensureInited) {
        ReflectionStructObjectInspector oi;
        if (t instanceof GenericArrayType) {
            GenericArrayType at = (GenericArrayType)t;
            return ObjectInspectorFactory.getStandardListObjectInspector(ObjectInspectorFactory.getReflectionObjectInspector(at.getGenericComponentType(), options, ensureInited));
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            if (List.class.isAssignableFrom((Class)pt.getRawType()) || Set.class.isAssignableFrom((Class)pt.getRawType())) {
                return ObjectInspectorFactory.getStandardListObjectInspector(ObjectInspectorFactory.getReflectionObjectInspector(pt.getActualTypeArguments()[0], options, ensureInited));
            }
            if (Map.class.isAssignableFrom((Class)pt.getRawType())) {
                return ObjectInspectorFactory.getStandardMapObjectInspector(ObjectInspectorFactory.getReflectionObjectInspector(pt.getActualTypeArguments()[0], options, ensureInited), ObjectInspectorFactory.getReflectionObjectInspector(pt.getActualTypeArguments()[1], options, ensureInited));
            }
            t = pt.getRawType();
        }
        if (!(t instanceof Class)) {
            throw new RuntimeException(ObjectInspectorFactory.class.getName() + " internal error:" + t);
        }
        Class c = (Class)t;
        if (PrimitiveObjectInspectorUtils.isPrimitiveJavaType(c)) {
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveJavaType(c).primitiveCategory);
        }
        if (PrimitiveObjectInspectorUtils.isPrimitiveJavaClass(c)) {
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveJavaClass(c).primitiveCategory);
        }
        if (PrimitiveObjectInspectorUtils.isPrimitiveWritableClass(c)) {
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveWritableClass(c).primitiveCategory);
        }
        if (Enum.class.isAssignableFrom(c)) {
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(PrimitiveObjectInspector.PrimitiveCategory.STRING);
        }
        assert (!List.class.isAssignableFrom(c));
        assert (!Map.class.isAssignableFrom(c));
        switch (options) {
            case JAVA: {
                oi = new ReflectionStructObjectInspector();
                break;
            }
            case THRIFT: {
                oi = TUnion.class.isAssignableFrom(c) ? new ThriftUnionObjectInspector() : new ThriftStructObjectInspector();
                break;
            }
            case PROTOCOL_BUFFERS: {
                oi = new ProtocolBuffersStructObjectInspector();
                break;
            }
            default: {
                throw new RuntimeException(ObjectInspectorFactory.class.getName() + ": internal error.");
            }
        }
        ReflectionStructObjectInspector prev = objectInspectorCache.asMap().putIfAbsent(t, oi);
        if (prev != null) {
            oi = prev;
        } else {
            try {
                oi.init(t, c, options);
            }
            finally {
                if (!oi.inited) {
                    objectInspectorCache.asMap().remove(t, oi);
                }
            }
        }
        return oi;
    }

    public static StandardListObjectInspector getStandardListObjectInspector(ObjectInspector listElementObjectInspector) {
        StandardListObjectInspector result = (StandardListObjectInspector)cachedStandardListObjectInspector.asMap().get(listElementObjectInspector);
        if (result == null) {
            result = new StandardListObjectInspector(listElementObjectInspector);
            StandardListObjectInspector prev = cachedStandardListObjectInspector.asMap().putIfAbsent(listElementObjectInspector, result);
            if (prev != null) {
                result = prev;
            }
        }
        return result;
    }

    public static StandardConstantListObjectInspector getStandardConstantListObjectInspector(ObjectInspector listElementObjectInspector, List<?> constantValue) {
        return new StandardConstantListObjectInspector(listElementObjectInspector, constantValue);
    }

    public static StandardMapObjectInspector getStandardMapObjectInspector(ObjectInspector mapKeyObjectInspector, ObjectInspector mapValueObjectInspector) {
        ArrayList<ObjectInspector> signature = new ArrayList<ObjectInspector>(2);
        signature.add(mapKeyObjectInspector);
        signature.add(mapValueObjectInspector);
        StandardMapObjectInspector result = (StandardMapObjectInspector)cachedStandardMapObjectInspector.asMap().get(signature);
        if (result == null) {
            result = new StandardMapObjectInspector(mapKeyObjectInspector, mapValueObjectInspector);
            StandardMapObjectInspector prev = cachedStandardMapObjectInspector.asMap().putIfAbsent(signature, result);
            if (prev != null) {
                result = prev;
            }
        }
        return result;
    }

    public static StandardConstantMapObjectInspector getStandardConstantMapObjectInspector(ObjectInspector mapKeyObjectInspector, ObjectInspector mapValueObjectInspector, Map<?, ?> constantValue) {
        return new StandardConstantMapObjectInspector(mapKeyObjectInspector, mapValueObjectInspector, constantValue);
    }

    public static StandardUnionObjectInspector getStandardUnionObjectInspector(List<ObjectInspector> unionObjectInspectors) {
        StandardUnionObjectInspector result = (StandardUnionObjectInspector)cachedStandardUnionObjectInspector.asMap().get(unionObjectInspectors);
        if (result == null) {
            result = new StandardUnionObjectInspector(unionObjectInspectors);
            StandardUnionObjectInspector prev = cachedStandardUnionObjectInspector.asMap().putIfAbsent(unionObjectInspectors, result);
            if (prev != null) {
                result = prev;
            }
        }
        return result;
    }

    public static StandardStructObjectInspector getStandardStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors) {
        return ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, structFieldObjectInspectors, null);
    }

    public static StandardStructObjectInspector getStandardStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structComments) {
        StandardStructObjectInspector result;
        ArrayList<List<Object>> signature = new ArrayList<List<Object>>(3);
        StringInternUtils.internStringsInList(structFieldNames);
        signature.add(structFieldNames);
        signature.add(structFieldObjectInspectors);
        if (structComments != null) {
            StringInternUtils.internStringsInList(structComments);
            signature.add(structComments);
        }
        if ((result = (StandardStructObjectInspector)cachedStandardStructObjectInspector.asMap().get(signature)) == null) {
            result = new StandardStructObjectInspector(structFieldNames, structFieldObjectInspectors, structComments);
            StandardStructObjectInspector prev = cachedStandardStructObjectInspector.asMap().putIfAbsent(signature, result);
            if (prev != null) {
                result = prev;
            }
        }
        return result;
    }

    public static StandardConstantStructObjectInspector getStandardConstantStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<?> value) {
        return new StandardConstantStructObjectInspector(structFieldNames, structFieldObjectInspectors, value);
    }

    public static UnionStructObjectInspector getUnionStructObjectInspector(List<StructObjectInspector> structObjectInspectors) {
        UnionStructObjectInspector result = (UnionStructObjectInspector)cachedUnionStructObjectInspector.getIfPresent(structObjectInspectors);
        if (result == null) {
            result = new UnionStructObjectInspector(structObjectInspectors);
            cachedUnionStructObjectInspector.put(structObjectInspectors, (Object)result);
        }
        return result;
    }

    public static ColumnarStructObjectInspector getColumnarStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors) {
        return ObjectInspectorFactory.getColumnarStructObjectInspector(structFieldNames, structFieldObjectInspectors, null);
    }

    public static ColumnarStructObjectInspector getColumnarStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structFieldComments) {
        ColumnarStructObjectInspector result;
        ArrayList<List<Object>> signature = new ArrayList<List<Object>>(3);
        signature.add(structFieldNames);
        signature.add(structFieldObjectInspectors);
        if (structFieldComments != null) {
            signature.add(structFieldComments);
        }
        if ((result = (ColumnarStructObjectInspector)cachedColumnarStructObjectInspector.asMap().get(signature)) == null) {
            result = new ColumnarStructObjectInspector(structFieldNames, structFieldObjectInspectors, structFieldComments);
            ColumnarStructObjectInspector prev = cachedColumnarStructObjectInspector.asMap().putIfAbsent(signature, result);
            if (prev != null) {
                result = prev;
            }
        }
        return result;
    }

    private ObjectInspectorFactory() {
    }

    public static enum ObjectInspectorOptions {
        JAVA,
        THRIFT,
        PROTOCOL_BUFFERS,
        AVRO;

    }
}

