/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import java.io.Serializable;
import java.util.Optional;
import java.util.stream.LongStream;
import org.apache.beam.sdk.io.synthetic.SyntheticSourceOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.base.AbstractInstant;

class SyntheticWatermark
implements Serializable {
    private SyntheticSourceOptions options;
    private final long endOffset;
    private Instant watermark;

    SyntheticWatermark(SyntheticSourceOptions options, long endOffset) {
        this.options = options;
        this.endOffset = endOffset;
        this.watermark = new Instant(0L);
    }

    Instant calculateNew(long currentOffset, Instant processingTime) {
        if (currentOffset >= this.endOffset) {
            this.watermark = BoundedWindow.TIMESTAMP_MAX_VALUE;
            return this.watermark;
        }
        Instant newWatermark = this.findLowestEventTimeInAdvance(currentOffset, processingTime).minus((ReadableDuration)Duration.millis((long)this.options.watermarkDriftMillis.intValue()));
        if (newWatermark.getMillis() > this.watermark.getMillis()) {
            this.watermark = newWatermark;
        }
        return this.watermark;
    }

    private Instant findLowestEventTimeInAdvance(long offset, Instant processingTime) {
        Optional<Instant> minEventTime = LongStream.range(offset, offset + (long)this.options.watermarkSearchInAdvanceCount.intValue()).mapToObj(element -> this.eventTime(element, processingTime)).min(AbstractInstant::compareTo);
        return minEventTime.orElse(this.eventTime(offset, processingTime));
    }

    private Instant eventTime(long offset, Instant processingTime) {
        return processingTime.minus((ReadableDuration)this.options.nextProcessingTimeDelay(offset));
    }
}

