/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.kafka.producer;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.kafka.consumer.KafkaConsumerField;
import org.apache.hop.pipeline.transforms.kafka.producer.KafkaProducerOutputData;
import org.apache.hop.pipeline.transforms.kafka.producer.KafkaProducerOutputMeta;
import org.apache.hop.pipeline.transforms.kafka.shared.KafkaFactory;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaProducerOutput
extends BaseTransform<KafkaProducerOutputMeta, KafkaProducerOutputData> {
    private static final Class<?> PKG = KafkaProducerOutputMeta.class;
    private KafkaFactory kafkaFactory;

    public KafkaProducerOutput(TransformMeta transformMeta, KafkaProducerOutputMeta meta, KafkaProducerOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline trans) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, trans);
        this.setKafkaFactory(KafkaFactory.defaultFactory());
    }

    void setKafkaFactory(KafkaFactory factory) {
        this.kafkaFactory = factory;
    }

    public boolean processRow() throws HopException {
        ProducerRecord producerRecord;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            if (((KafkaProducerOutputData)this.data).kafkaProducer != null) {
                ((KafkaProducerOutputData)this.data).kafkaProducer.close();
            }
            return false;
        }
        if (this.first) {
            ((KafkaProducerOutputData)this.data).keyFieldIndex = this.getInputRowMeta().indexOfValue(this.resolve(((KafkaProducerOutputMeta)this.meta).getKeyField()));
            ((KafkaProducerOutputData)this.data).messageFieldIndex = this.getInputRowMeta().indexOfValue(this.resolve(((KafkaProducerOutputMeta)this.meta).getMessageField()));
            ((KafkaProducerOutputData)this.data).keyValueMeta = this.getInputRowMeta().getValueMeta(((KafkaProducerOutputData)this.data).keyFieldIndex);
            ((KafkaProducerOutputData)this.data).msgValueMeta = this.getInputRowMeta().getValueMeta(((KafkaProducerOutputData)this.data).messageFieldIndex);
            ((KafkaProducerOutputData)this.data).kafkaProducer = this.kafkaFactory.producer((KafkaProducerOutputMeta)this.meta, arg_0 -> ((KafkaProducerOutput)this).resolve(arg_0), KafkaConsumerField.Type.fromValueMeta(((KafkaProducerOutputData)this.data).keyValueMeta), KafkaConsumerField.Type.fromValueMeta(((KafkaProducerOutputData)this.data).msgValueMeta));
            ((KafkaProducerOutputData)this.data).isOpen = true;
            this.first = false;
        }
        if (!((KafkaProducerOutputData)this.data).isOpen) {
            return false;
        }
        if (((KafkaProducerOutputData)this.data).keyFieldIndex < 0 || this.getInputRowMeta().isNull(r, ((KafkaProducerOutputData)this.data).keyFieldIndex) || StringUtils.isEmpty((String)r[((KafkaProducerOutputData)this.data).keyFieldIndex].toString())) {
            producerRecord = new ProducerRecord(this.resolve(((KafkaProducerOutputMeta)this.meta).getTopic()), r[((KafkaProducerOutputData)this.data).messageFieldIndex]);
        } else {
            Object nativeObject = this.getInputRowMeta().getValueMeta(((KafkaProducerOutputData)this.data).messageFieldIndex).getNativeDataType(r[((KafkaProducerOutputData)this.data).messageFieldIndex]);
            producerRecord = new ProducerRecord(this.resolve(((KafkaProducerOutputMeta)this.meta).getTopic()), (Object)this.getInputRowMeta().getString(r, ((KafkaProducerOutputData)this.data).keyFieldIndex), nativeObject);
        }
        ((KafkaProducerOutputData)this.data).kafkaProducer.send(producerRecord);
        this.incrementLinesOutput();
        this.putRow(this.getInputRowMeta(), r);
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"KafkaConsumerOutput.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public void stopRunning() {
        if (((KafkaProducerOutputData)this.data).kafkaProducer != null && ((KafkaProducerOutputData)this.data).isOpen) {
            ((KafkaProducerOutputData)this.data).isOpen = false;
            ((KafkaProducerOutputData)this.data).kafkaProducer.flush();
            ((KafkaProducerOutputData)this.data).kafkaProducer.close();
        }
    }
}

