/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.kafka.consumer;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.TransformWithMappingMeta;
import org.apache.hop.pipeline.transform.TransformErrorMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.kafka.consumer.KafkaConsumerField;
import org.apache.hop.pipeline.transforms.kafka.consumer.KafkaConsumerInput;
import org.apache.hop.pipeline.transforms.kafka.consumer.KafkaConsumerInputData;
import org.apache.hop.pipeline.transforms.pipelineexecutor.PipelineExecutorMeta;
import org.w3c.dom.Node;

@Transform(id="KafkaConsumer", image="KafkaConsumerInput.svg", name="i18n::KafkaConsumer.TypeLongDesc", description="i18n::KafkaConsumer.TypeTooltipDesc", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Streaming", keywords={"i18n::KafkaConsumerInputMeta.keyword"}, documentationUrl="/pipeline/transforms/kafkaconsumer.html")
@InjectionSupported(localizationPrefix="KafkaConsumerInputMeta.Injection.", groups={"CONFIGURATION_PROPERTIES"})
public class KafkaConsumerInputMeta
extends TransformWithMappingMeta<KafkaConsumerInput, KafkaConsumerInputData>
implements Cloneable {
    private static final Class<?> PKG = KafkaConsumerInputMeta.class;
    public static final String NUM_MESSAGES = "numMessages";
    public static final String DURATION = "duration";
    public static final String SUB_TRANSFORM = "subTransform";
    public static final String TOPIC = "topic";
    public static final String CONSUMER_GROUP = "consumerGroup";
    public static final String PIPELINE_PATH = "pipelinePath";
    public static final String BATCH_SIZE = "batchSize";
    public static final String BATCH_DURATION = "batchDuration";
    public static final String DIRECT_BOOTSTRAP_SERVERS = "directBootstrapServers";
    public static final String ADVANCED_CONFIG = "advancedConfig";
    public static final String CONFIG_OPTION = "option";
    public static final String OPTION_PROPERTY = "property";
    public static final String OPTION_VALUE = "value";
    public static final String TOPIC_FIELD_NAME = "topic";
    public static final String OFFSET_FIELD_NAME = "offset";
    public static final String PARTITION_FIELD_NAME = "partition";
    public static final String TIMESTAMP_FIELD_NAME = "timestamp";
    public static final String OUTPUT_FIELD_TAG_NAME = "OutputField";
    public static final String KAFKA_NAME_ATTRIBUTE = "kafkaName";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String AUTO_COMMIT = "AUTO_COMMIT";
    @Injection(name="pipelinePath")
    protected String filename = "";
    @Injection(name="numMessages")
    protected String batchSize = "1000";
    @Injection(name="duration")
    protected String batchDuration = "1000";
    @Injection(name="subTransform")
    protected String subTransform = "";
    @Injection(name="DIRECT_BOOTSTRAP_SERVERS")
    private String directBootstrapServers;
    @Injection(name="TOPICS")
    private List<String> topics;
    @Injection(name="CONSUMER_GROUP")
    private String consumerGroup;
    @InjectionDeep(prefix="KEY")
    private KafkaConsumerField keyField;
    @InjectionDeep(prefix="MESSAGE")
    private KafkaConsumerField messageField;
    @Injection(name="NAMES", group="CONFIGURATION_PROPERTIES")
    protected transient List<String> injectedConfigNames;
    @Injection(name="VALUES", group="CONFIGURATION_PROPERTIES")
    protected transient List<String> injectedConfigValues;
    @Injection(name="AUTO_COMMIT")
    private boolean autoCommit = true;
    private Map<String, String> config = new LinkedHashMap<String, String>();
    private KafkaConsumerField topicField;
    private KafkaConsumerField offsetField;
    private KafkaConsumerField partitionField;
    private KafkaConsumerField timestampField;
    MappingMetaRetriever mappingMetaRetriever = TransformWithMappingMeta::loadMappingMeta;

    public KafkaConsumerInputMeta() {
        this.topics = new ArrayList<String>();
        this.keyField = new KafkaConsumerField(KafkaConsumerField.Name.KEY, BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.KeyField", (String[])new String[0]));
        this.messageField = new KafkaConsumerField(KafkaConsumerField.Name.MESSAGE, BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.MessageField", (String[])new String[0]));
        this.topicField = new KafkaConsumerField(KafkaConsumerField.Name.TOPIC, BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.TopicField", (String[])new String[0]));
        this.partitionField = new KafkaConsumerField(KafkaConsumerField.Name.PARTITION, BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.PartitionField", (String[])new String[0]), KafkaConsumerField.Type.Integer);
        this.offsetField = new KafkaConsumerField(KafkaConsumerField.Name.OFFSET, BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.OffsetField", (String[])new String[0]), KafkaConsumerField.Type.Integer);
        this.timestampField = new KafkaConsumerField(KafkaConsumerField.Name.TIMESTAMP, BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.TimestampField", (String[])new String[0]), KafkaConsumerField.Type.Integer);
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) {
        this.setFilename(XmlHandler.getTagValue((Node)transformNode, (String)PIPELINE_PATH));
        this.topics = new ArrayList<String>();
        List topicsNode = XmlHandler.getNodes((Node)transformNode, (String)"topic");
        topicsNode.forEach(node -> {
            String displayName = XmlHandler.getNodeValue((Node)node);
            this.topics.add(displayName);
        });
        this.setConsumerGroup(XmlHandler.getTagValue((Node)transformNode, (String)CONSUMER_GROUP));
        String subTransformTag = XmlHandler.getTagValue((Node)transformNode, (String)SUB_TRANSFORM);
        if (!StringUtils.isEmpty((String)subTransformTag)) {
            this.setSubTransform(subTransformTag);
        }
        this.setBatchSize(XmlHandler.getTagValue((Node)transformNode, (String)BATCH_SIZE));
        this.setBatchDuration(XmlHandler.getTagValue((Node)transformNode, (String)BATCH_DURATION));
        this.setDirectBootstrapServers(XmlHandler.getTagValue((Node)transformNode, (String)DIRECT_BOOTSTRAP_SERVERS));
        String autoCommitValue = XmlHandler.getTagValue((Node)transformNode, (String)AUTO_COMMIT);
        this.setAutoCommit("Y".equals(autoCommitValue) || StringUtils.isEmpty((String)autoCommitValue));
        List ofNode = XmlHandler.getNodes((Node)transformNode, (String)OUTPUT_FIELD_TAG_NAME);
        ofNode.forEach(node -> {
            String displayName = XmlHandler.getNodeValue((Node)node);
            String kafkaName = XmlHandler.getTagAttribute((Node)node, (String)KAFKA_NAME_ATTRIBUTE);
            String type = XmlHandler.getTagAttribute((Node)node, (String)TYPE_ATTRIBUTE);
            KafkaConsumerField field = new KafkaConsumerField(KafkaConsumerField.Name.valueOf(kafkaName.toUpperCase()), displayName, KafkaConsumerField.Type.valueOf(type));
            this.setField(field);
        });
        this.config = new LinkedHashMap<String, String>();
        Optional.ofNullable(XmlHandler.getSubNode((Node)transformNode, (String)ADVANCED_CONFIG)).map(Node::getChildNodes).ifPresent(nodes -> IntStream.range(0, nodes.getLength()).mapToObj(nodes::item).filter(node -> node.getNodeType() == 1).forEach(node -> {
            if (CONFIG_OPTION.equals(node.getNodeName())) {
                this.config.put(node.getAttributes().getNamedItem(OPTION_PROPERTY).getTextContent(), node.getAttributes().getNamedItem(OPTION_VALUE).getTextContent());
            } else {
                this.config.put(node.getNodeName(), node.getTextContent());
            }
        }));
    }

    protected void setField(KafkaConsumerField field) {
        field.getKafkaName().setFieldOnMeta(this, field);
    }

    public void setDefault() {
        this.batchSize = "1000";
        this.batchDuration = "1000";
    }

    public RowMeta getRowMeta(String origin, IVariables variables) throws HopTransformException {
        RowMeta rowMeta = new RowMeta();
        this.putFieldOnRowMeta(this.getKeyField(), (IRowMeta)rowMeta, origin, variables);
        this.putFieldOnRowMeta(this.getMessageField(), (IRowMeta)rowMeta, origin, variables);
        this.putFieldOnRowMeta(this.getTopicField(), (IRowMeta)rowMeta, origin, variables);
        this.putFieldOnRowMeta(this.getPartitionField(), (IRowMeta)rowMeta, origin, variables);
        this.putFieldOnRowMeta(this.getOffsetField(), (IRowMeta)rowMeta, origin, variables);
        this.putFieldOnRowMeta(this.getTimestampField(), (IRowMeta)rowMeta, origin, variables);
        return rowMeta;
    }

    private void putFieldOnRowMeta(KafkaConsumerField field, IRowMeta rowMeta, String origin, IVariables variables) throws HopTransformException {
        if (field != null && !StringUtils.isEmpty((String)field.getOutputName())) {
            try {
                String value = variables.resolve(field.getOutputName());
                IValueMeta v = ValueMetaFactory.createValueMeta((String)value, (int)field.getOutputType().getIValueMetaType());
                v.setOrigin(origin);
                rowMeta.addValueMeta(v);
            }
            catch (Exception e) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"KafkaConsumerInputMeta.UnableToCreateValueType", (String[])new String[]{field.getOutputName()}), (Throwable)e);
            }
        }
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder();
        this.getTopics().forEach(topic -> xml.append("    ").append(XmlHandler.addTagValue((String)"topic", (String)topic)));
        xml.append("    ").append(XmlHandler.addTagValue((String)CONSUMER_GROUP, (String)this.consumerGroup));
        xml.append("    ").append(XmlHandler.addTagValue((String)PIPELINE_PATH, (String)this.filename));
        xml.append("    ").append(XmlHandler.addTagValue((String)SUB_TRANSFORM, (String)this.getSubTransform()));
        xml.append("    ").append(XmlHandler.addTagValue((String)BATCH_SIZE, (String)this.batchSize));
        xml.append("    ").append(XmlHandler.addTagValue((String)BATCH_DURATION, (String)this.batchDuration));
        xml.append("    ").append(XmlHandler.addTagValue((String)DIRECT_BOOTSTRAP_SERVERS, (String)this.directBootstrapServers));
        xml.append("    ").append(XmlHandler.addTagValue((String)AUTO_COMMIT, (boolean)this.autoCommit));
        this.getFieldDefinitions().forEach(field -> xml.append("    ").append(XmlHandler.addTagValue((String)OUTPUT_FIELD_TAG_NAME, (String)field.getOutputName(), (boolean)true, (String[])new String[]{KAFKA_NAME_ATTRIBUTE, field.getKafkaName().toString(), TYPE_ATTRIBUTE, field.getOutputType().toString()})));
        xml.append("    ").append(XmlHandler.openTag((String)ADVANCED_CONFIG)).append(Const.CR);
        this.getConfig().forEach((key, value) -> xml.append("        ").append(XmlHandler.addTagValue((String)CONFIG_OPTION, (String)"", (boolean)true, (String[])new String[]{OPTION_PROPERTY, key, OPTION_VALUE, value})));
        xml.append("    ").append(XmlHandler.closeTag((String)ADVANCED_CONFIG)).append(Const.CR);
        return xml.toString();
    }

    public List<KafkaConsumerField> getFieldDefinitions() {
        return new ArrayList<KafkaConsumerField>(Arrays.asList(this.getKeyField(), this.getMessageField(), this.getTopicField(), this.getPartitionField(), this.getOffsetField(), this.getTimestampField()));
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public Map<String, String> getConfig() {
        this.applyInjectedProperties();
        return this.config;
    }

    protected void applyInjectedProperties() {
        if (this.injectedConfigNames != null || this.injectedConfigValues != null) {
            Preconditions.checkState((this.injectedConfigNames != null ? 1 : 0) != 0, (Object)"Options names were not injected");
            Preconditions.checkState((this.injectedConfigValues != null ? 1 : 0) != 0, (Object)"Options values were not injected");
            Preconditions.checkState((this.injectedConfigNames.size() == this.injectedConfigValues.size() ? 1 : 0) != 0, (Object)"Injected different number of options names and value");
            this.setConfig(IntStream.range(0, this.injectedConfigNames.size()).boxed().collect(Collectors.toMap(this.injectedConfigNames::get, this.injectedConfigValues::get, (v1, v2) -> v1, LinkedHashMap::new)));
            this.injectedConfigNames = null;
            this.injectedConfigValues = null;
        }
    }

    public KafkaConsumerInputMeta clone() {
        return this.copyObject();
    }

    public KafkaConsumerInputMeta copyObject() {
        KafkaConsumerInputMeta newClone = (KafkaConsumerInputMeta)super.clone();
        newClone.topics = new ArrayList<String>(this.topics);
        newClone.keyField = new KafkaConsumerField(this.keyField);
        newClone.messageField = new KafkaConsumerField(this.messageField);
        if (null != this.injectedConfigNames) {
            newClone.injectedConfigNames = new ArrayList<String>(this.injectedConfigNames);
        }
        if (null != this.injectedConfigValues) {
            newClone.injectedConfigValues = new ArrayList<String>(this.injectedConfigValues);
        }
        newClone.config = new LinkedHashMap<String, String>(this.config);
        newClone.topicField = new KafkaConsumerField(this.topicField);
        newClone.offsetField = new KafkaConsumerField(this.offsetField);
        newClone.partitionField = new KafkaConsumerField(this.partitionField);
        newClone.timestampField = new KafkaConsumerField(this.timestampField);
        return newClone;
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            TransformErrorMeta transformErrorMeta;
            PipelineMeta pipelineMeta = this.mappingMetaRetriever.get(this, metadataProvider, variables);
            if (!StringUtils.isEmpty((String)this.getSubTransform())) {
                String realSubTransformName = variables.resolve(this.getSubTransform());
                rowMeta.addRowMeta(pipelineMeta.getPrevTransformFields(variables, realSubTransformName));
                pipelineMeta.getTransforms().stream().filter(transformMeta -> transformMeta.getName().equals(realSubTransformName)).findFirst().ifPresent(transformMeta -> {
                    try {
                        transformMeta.getTransform().getFields(rowMeta, origin, info, nextTransform, variables, metadataProvider);
                    }
                    catch (HopTransformException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            if ((transformErrorMeta = this.getParentTransformMeta().getTransformErrorMeta()) != null && transformErrorMeta.getTargetTransform().getName().equals(nextTransform.getName())) {
                rowMeta.addValueMeta(this.createValueMetaString(this.getKeyField().getOutputName()));
                rowMeta.addValueMeta(this.createValueMetaString(this.getMessageField().getOutputName()));
                rowMeta.addValueMeta(this.createValueMetaString(this.getTopicField().getOutputName()));
                rowMeta.addValueMeta(this.createValueMetaInteger(this.getPartitionField().getOutputName()));
                rowMeta.addValueMeta(this.createValueMetaInteger(this.getOffsetField().getOutputName()));
                rowMeta.addValueMeta(this.createValueMetaInteger(this.getTimestampField().getOutputName()));
            }
        }
        catch (HopException e) {
            this.getLog().logDebug("could not get fields, probable AEL");
            rowMeta.addRowMeta((IRowMeta)this.getRowMeta(origin, variables));
        }
    }

    private IValueMeta createValueMetaString(String name) {
        ValueMetaString vm = new ValueMetaString(name);
        vm.setOrigin(this.getParentTransformMeta().getName());
        return vm;
    }

    private IValueMeta createValueMetaInteger(String name) {
        ValueMetaInteger vm = new ValueMetaInteger(name);
        vm.setOrigin(this.getParentTransformMeta().getName());
        return vm;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        long duration = Long.MIN_VALUE;
        try {
            duration = Long.parseLong(variables.resolve(this.getBatchDuration()));
        }
        catch (NumberFormatException e) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"KafkaConsumerInputMeta.CheckResult.NaN", (String[])new String[]{"Duration"}), (ICheckResultSource)transformMeta));
        }
        long size = Long.MIN_VALUE;
        try {
            size = Long.parseLong(variables.resolve(this.getBatchSize()));
        }
        catch (NumberFormatException e) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"KafkaConsumerInputMeta.CheckResult.NaN", (String[])new String[]{"Number of records"}), (ICheckResultSource)transformMeta));
        }
        if (duration == 0L && size == 0L) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"KafkaConsumerInputMeta.CheckResult.NoBatchDefined", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{StringUtils.isNotEmpty((String)this.filename)};
    }

    public String[] getReferencedObjectDescriptions() {
        return new String[]{"Kafka Pipeline"};
    }

    public String getActiveReferencedObjectDescription() {
        return "Running Kafka Pipeline";
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return PipelineExecutorMeta.loadMappingMeta((TransformWithMappingMeta)this, (IHopMetadataProvider)metadataProvider, (IVariables)variables);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public String getBatchDuration() {
        return this.batchDuration;
    }

    public void setBatchDuration(String batchDuration) {
        this.batchDuration = batchDuration;
    }

    public String getSubTransform() {
        return this.subTransform;
    }

    public void setSubTransform(String subTransform) {
        this.subTransform = subTransform;
    }

    public String getDirectBootstrapServers() {
        return this.directBootstrapServers;
    }

    public void setDirectBootstrapServers(String directBootstrapServers) {
        this.directBootstrapServers = directBootstrapServers;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public KafkaConsumerField getKeyField() {
        return this.keyField;
    }

    public void setKeyField(KafkaConsumerField keyField) {
        this.keyField = keyField;
    }

    public KafkaConsumerField getMessageField() {
        return this.messageField;
    }

    public void setMessageField(KafkaConsumerField messageField) {
        this.messageField = messageField;
    }

    public List<String> getInjectedConfigNames() {
        return this.injectedConfigNames;
    }

    public void setInjectedConfigNames(List<String> injectedConfigNames) {
        this.injectedConfigNames = injectedConfigNames;
    }

    public List<String> getInjectedConfigValues() {
        return this.injectedConfigValues;
    }

    public void setInjectedConfigValues(List<String> injectedConfigValues) {
        this.injectedConfigValues = injectedConfigValues;
    }

    public KafkaConsumerField getTopicField() {
        return this.topicField;
    }

    public void setTopicField(KafkaConsumerField topicField) {
        this.topicField = topicField;
    }

    public KafkaConsumerField getOffsetField() {
        return this.offsetField;
    }

    public void setOffsetField(KafkaConsumerField offsetField) {
        this.offsetField = offsetField;
    }

    public KafkaConsumerField getPartitionField() {
        return this.partitionField;
    }

    public void setPartitionField(KafkaConsumerField partitionField) {
        this.partitionField = partitionField;
    }

    public KafkaConsumerField getTimestampField() {
        return this.timestampField;
    }

    public void setTimestampField(KafkaConsumerField timestampField) {
        this.timestampField = timestampField;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    @FunctionalInterface
    static interface MappingMetaRetriever {
        public PipelineMeta get(TransformWithMappingMeta var1, IHopMetadataProvider var2, IVariables var3) throws HopException;
    }
}

