/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventprocessorhost.BaseLease;
import com.microsoft.azure.eventprocessorhost.EventHubClientFactory;
import com.microsoft.azure.eventprocessorhost.EventProcessorHost;
import com.microsoft.azure.eventprocessorhost.EventProcessorOptions;
import com.microsoft.azure.eventprocessorhost.ICheckpointManager;
import com.microsoft.azure.eventprocessorhost.IEventProcessorFactory;
import com.microsoft.azure.eventprocessorhost.ILeaseManager;
import com.microsoft.azure.eventprocessorhost.PartitionContext;
import com.microsoft.azure.eventprocessorhost.PartitionManagerOptions;
import java.util.concurrent.ScheduledExecutorService;

final class HostContext {
    private final ScheduledExecutorService executor;
    private final EventProcessorHost host;
    private final String hostName;
    private final String eventHubPath;
    private final String consumerGroupName;
    private final EventHubClientFactory eventHubClientFactory;
    private final ILeaseManager leaseManager;
    private final ICheckpointManager checkpointManager;
    private EventProcessorOptions eventProcessorOptions = null;
    private IEventProcessorFactory<?> processorFactory = null;

    HostContext(ScheduledExecutorService executor, EventProcessorHost host, String hostName, String eventHubPath, String consumerGroupName, EventHubClientFactory eventHubClientFactory, ILeaseManager leaseManager, ICheckpointManager checkpointManager) {
        this.executor = executor;
        this.host = host;
        this.hostName = hostName;
        this.eventHubPath = eventHubPath;
        this.consumerGroupName = consumerGroupName;
        this.eventHubClientFactory = eventHubClientFactory;
        this.leaseManager = leaseManager;
        this.checkpointManager = checkpointManager;
    }

    ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    String getHostName() {
        return this.hostName;
    }

    String getEventHubPath() {
        return this.eventHubPath;
    }

    String getConsumerGroupName() {
        return this.consumerGroupName;
    }

    EventHubClientFactory getEventHubClientFactory() {
        return this.eventHubClientFactory;
    }

    ILeaseManager getLeaseManager() {
        return this.leaseManager;
    }

    ICheckpointManager getCheckpointManager() {
        return this.checkpointManager;
    }

    PartitionManagerOptions getPartitionManagerOptions() {
        return this.host.getPartitionManagerOptions();
    }

    EventProcessorOptions getEventProcessorOptions() {
        return this.eventProcessorOptions;
    }

    void setEventProcessorOptions(EventProcessorOptions epo) {
        this.eventProcessorOptions = epo;
    }

    IEventProcessorFactory<?> getEventProcessorFactory() {
        return this.processorFactory;
    }

    void setEventProcessorFactory(IEventProcessorFactory<?> pf) {
        this.processorFactory = pf;
    }

    String withHost(String logMessage) {
        return "host " + this.hostName + ": " + logMessage;
    }

    String withHostAndPartition(String partitionId, String logMessage) {
        return this.withHost(partitionId + ": " + logMessage);
    }

    String withHostAndPartition(PartitionContext context, String logMessage) {
        return this.withHostAndPartition(context.getPartitionId(), logMessage);
    }

    String withHostAndPartition(BaseLease lease, String logMessage) {
        return this.withHostAndPartition(lease.getPartitionId(), logMessage);
    }
}

