/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.metrics;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.metrics.Meter;
import com.google.cloud.bigtable.metrics.Timer;

@InternalApi
public class RpcMetrics {
    private final Timer operationTimer;
    private final Timer rpcTimer;
    private final Meter retryMeter;
    private final Meter failureMeter;
    private final Meter retriesExhaustedMeter;

    public static RpcMetrics createRpcMetrics(String methodName) {
        String prefix = "grpc.method." + methodName;
        return new RpcMetrics(BigtableClientMetrics.timer(BigtableClientMetrics.MetricLevel.Info, prefix + ".operation.latency"), BigtableClientMetrics.timer(BigtableClientMetrics.MetricLevel.Debug, prefix + ".rpc.latency"), BigtableClientMetrics.meter(BigtableClientMetrics.MetricLevel.Info, prefix + ".retries.performed"), BigtableClientMetrics.meter(BigtableClientMetrics.MetricLevel.Info, prefix + ".failure"), BigtableClientMetrics.meter(BigtableClientMetrics.MetricLevel.Info, prefix + ".retries.exhausted"));
    }

    private RpcMetrics(Timer operationTimer, Timer rpcTimer, Meter retryCounter, Meter failureCounter, Meter retriesExhaustedCounter) {
        this.operationTimer = operationTimer;
        this.rpcTimer = rpcTimer;
        this.retryMeter = retryCounter;
        this.failureMeter = failureCounter;
        this.retriesExhaustedMeter = retriesExhaustedCounter;
    }

    public Timer.Context timeOperation() {
        return this.operationTimer.time();
    }

    public Timer.Context timeRpc() {
        return this.rpcTimer.time();
    }

    public void markRetry() {
        this.retryMeter.mark();
    }

    public void markFailure() {
        this.failureMeter.mark();
    }

    public void markRetriesExhasted() {
        this.retriesExhaustedMeter.mark();
    }
}

