/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.cypher;

import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.neo4j.transforms.cypher.Cypher;
import org.neo4j.driver.Result;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionWork;

public class CypherTransactionWork
implements TransactionWork<Void> {
    private final Cypher transform;
    private final Object[] currentRow;
    private final boolean unwind;
    private String cypher;
    private Map<String, Object> unwindMap;

    public CypherTransactionWork(Cypher transform, Object[] currentRow, boolean unwind, String cypher, Map<String, Object> unwindMap) {
        this.transform = transform;
        this.currentRow = currentRow;
        this.unwind = unwind;
        this.cypher = cypher;
        this.unwindMap = unwindMap;
    }

    public Void execute(Transaction tx) {
        try {
            Result result = tx.run(this.cypher, this.unwindMap);
            this.transform.getResultRows(result, this.currentRow, this.unwind);
            return null;
        }
        catch (HopException e) {
            throw new RuntimeException("Unable to execute cypher statement '" + this.cypher + "'", e);
        }
    }

    public String getCypher() {
        return this.cypher;
    }

    public void setCypher(String cypher) {
        this.cypher = cypher;
    }

    public Map<String, Object> getUnwindMap() {
        return this.unwindMap;
    }

    public void setUnwindMap(Map<String, Object> unwindMap) {
        this.unwindMap = unwindMap;
    }
}

